/*
 * Decompiled with CFR 0.152.
 */
package dc.android.libs.stat;

import dc.android.common.BaseApplication;
import dc.android.common.BridgeContext;
import dc.android.common.StatContext;
import dc.android.manager.CollectManager;
import dc.android.manager.SendManager;
import dc.common.Logger;

public class BehaviorInstance {
    private boolean isReport = true;
    private SendManager manager;
    private CollectManager collectManager;

    private BehaviorInstance() {
    }

    public static BehaviorInstance getInstance() {
        return Holder.INSTANCE;
    }

    public void setEnable(boolean isEnable) {
        this.isReport = isEnable;
    }

    public void init() {
        if (!this.isReport || !BridgeContext.isReport) {
            return;
        }
        this.manager = new SendManager(BaseApplication.getContext(), message -> Logger.w((Object[])new Object[]{this.getClass().getName(), message}));
        this.collectManager = new CollectManager(BaseApplication.getContext());
    }

    public void sendDingTalk(String msg) {
        this.sendDingTalk(msg, false);
    }

    public void sendDingTalk(String msg, boolean isDevices) {
        this.sendDingTalk(StatContext.KEY_DING_TYPE_TEXT, msg, isDevices);
    }

    public void sendDingTalk(String type, String msg, boolean isDevices) {
        if (null == this.manager) {
            return;
        }
        this.manager.sendDingTalk(type, isDevices && null != this.collectManager ? this.collectManager.collect(msg) : msg);
    }

    private static class Holder {
        private static final BehaviorInstance INSTANCE = new BehaviorInstance();

        private Holder() {
        }
    }
}

