package dc.android.libs.swipe;

import android.content.Context;
import android.util.AttributeSet;

/**
 * @author senrsl
 * @ClassName: SwipeDefaultFrameLayout
 * @Package: dc.android.libs.swipe
 * @CreateTime: 2019/8/16 4:24 PM
 */
public class SwipeDefaultFrameLayout extends SwipeFrameLayout {

    private SwipeDefaultHeader header;

    public SwipeDefaultFrameLayout(Context context) {
        super(context);
        initViews();
    }

    public SwipeDefaultFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        initViews();
    }

    public SwipeDefaultFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        initViews();
    }

    private void initViews() {
        header = new SwipeDefaultHeader(getContext());
        setHeaderView(header);
        addSwipeUIListener(header);
    }

    public SwipeDefaultHeader getHeader() {
        return header;
    }

    /**
     * Specify the last update time by this key string
     *
     * @param key
     */
    public void setLastUpdateTimeKey(String key) {
        if (header != null) {
            header.setLastUpdateTimeKey(key);
        }
    }

    /**
     * Using an object to specify the last update time.
     *
     * @param object
     */
    public void setLastUpdateTimeRelateObject(Object object) {
        if (header != null) {
            header.setLastUpdateTimeRelateObject(object);
        }
    }
}
