package dc.android.libs.swipe;

import android.view.View;
import android.widget.AbsListView;
import dc.android.libs.swipe.listener.ISwipeListener;
import dc.common.Logger;

/**
 * @author senrsl
 * @ClassName: SwipeDefaultListenerImpl
 * @Package: dc.android.libs.swipe
 * @CreateTime: 2019/8/16 4:22 PM
 */
public abstract class SwipeDefaultListenerImpl implements ISwipeListener {

    @Override
    public boolean checkCanDoRefresh(SwipeFrameLayout frame, View content, View header) {
        return checkContentCanBePulledDown(frame, content, header);
    }

    /**
     * Default implement for check can perform pull to refresh
     *
     * @param frame
     * @param content
     * @param header
     * @return
     */
    public static boolean checkContentCanBePulledDown(SwipeFrameLayout frame, View content, View header) {
        if (SwipeContext.isDebugSwipe) Logger.w(frame, content, header);
        return !canChildScrollUp(content);
    }

    /**
     * 判断子View是否可以往上滑
     *
     * @param view
     * @return
     */
    public static boolean canChildScrollUp(View view) {
        if (android.os.Build.VERSION.SDK_INT < 14) {
            if (view instanceof AbsListView) {
                final AbsListView absListView = (AbsListView) view;
                return absListView.getChildCount() > 0
                        && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0)
                        .getTop() < absListView.getPaddingTop());
            } else {
                return view.getScrollY() > 0;
            }
        } else {
            return view.canScrollVertically(-1);
        }
    }


}
