package dc.android.libs.swipe;

import dc.android.libs.swipe.indicator.SwipeIndicator;
import dc.android.libs.swipe.listener.ISwipeUIListener;

/**
 * 链表封装
 *
 * @author senrsl
 * @ClassName: SwipeUIListenerImpl
 * @Package: dc.android.libs.swipe
 * @CreateTime: 2019/8/16 4:06 PM
 */
public class SwipeUIListenerImpl implements ISwipeUIListener {

    private ISwipeUIListener listener;
    private SwipeUIListenerImpl mNext;

    private boolean contains(ISwipeUIListener handler) {
        return listener != null && listener == handler;
    }

    private SwipeUIListenerImpl() {

    }

    public boolean hasHandler() {
        return listener != null;
    }

    private ISwipeUIListener getHandler() {
        return listener;
    }

    public static void addHandler(SwipeUIListenerImpl head, ISwipeUIListener handler) {

        if (null == handler) {
            return;
        }
        if (head == null) {
            return;
        }
        if (null == head.listener) {
            head.listener = handler;
            return;
        }

        SwipeUIListenerImpl current = head;
        for (; ; current = current.mNext) {

            // duplicated
            if (current.contains(handler)) {
                return;
            }
            if (current.mNext == null) {
                break;
            }
        }

        SwipeUIListenerImpl newHolder = new SwipeUIListenerImpl();
        newHolder.listener = handler;
        current.mNext = newHolder;
    }

    public static SwipeUIListenerImpl create() {
        return new SwipeUIListenerImpl();
    }

    public static SwipeUIListenerImpl removeHandler(SwipeUIListenerImpl head, ISwipeUIListener handler) {
        if (head == null || handler == null || null == head.listener) {
            return head;
        }

        SwipeUIListenerImpl current = head;
        SwipeUIListenerImpl pre = null;
        do {

            // delete current: link pre to next, unlink next from current;
            // pre will no change, current move to next element;
            if (current.contains(handler)) {

                // current is head
                if (pre == null) {

                    head = current.mNext;
                    current.mNext = null;

                    current = head;
                } else {

                    pre.mNext = current.mNext;
                    current.mNext = null;
                    current = pre.mNext;
                }
            } else {
                pre = current;
                current = current.mNext;
            }

        } while (current != null);

        if (head == null) {
            head = new SwipeUIListenerImpl();
        }
        return head;
    }

    @Override
    public void onUIReset(SwipeFrameLayout frame) {
        SwipeUIListenerImpl current = this;
        do {
            ISwipeUIListener handler = current.getHandler();
            if (null != handler) {
                handler.onUIReset(frame);
            }
        } while ((current = current.mNext) != null);
    }

    @Override
    public void onUIRefreshPrepare(SwipeFrameLayout frame) {
        if (!hasHandler()) {
            return;
        }
        SwipeUIListenerImpl current = this;
        do {
            ISwipeUIListener handler = current.getHandler();
            if (null != handler) {
                handler.onUIRefreshPrepare(frame);
            }
        } while ((current = current.mNext) != null);
    }

    @Override
    public void onUIRefreshBegin(SwipeFrameLayout frame) {
        SwipeUIListenerImpl current = this;
        do {
            ISwipeUIListener handler = current.getHandler();
            if (null != handler) {
                handler.onUIRefreshBegin(frame);
            }
        } while ((current = current.mNext) != null);
    }

    @Override
    public void onUIRefreshComplete(SwipeFrameLayout frame) {
        SwipeUIListenerImpl current = this;
        do {
            ISwipeUIListener handler = current.getHandler();
            if (null != handler) {
                handler.onUIRefreshComplete(frame);
            }
        } while ((current = current.mNext) != null);
    }

    @Override
    public void onUIPositionChange(SwipeFrameLayout frame, boolean isUnderTouch, byte status, SwipeIndicator indicator) {
        SwipeUIListenerImpl current = this;
        do {
            ISwipeUIListener handler = current.getHandler();
            if (null != handler) {
                handler.onUIPositionChange(frame, isUnderTouch, status, indicator);
            }
        } while ((current = current.mNext) != null);
    }
}
