package dc.android.libs.swipe.listener;

import android.view.View;
import dc.android.libs.swipe.SwipeFrameLayout;

/**
 * 功能拦截
 *
 * @author senrsl
 * @ClassName: SwipeListener
 * @Package: dc.android.libs.swipe
 * @CreateTime: 2019/8/16 4:04 PM
 */
public interface ISwipeListener {

    /**
     * 检查是否可以刷新
     *
     * @param layout
     * @param content
     * @param header
     * @return
     */
    boolean checkCanDoRefresh(SwipeFrameLayout layout, View content, View header);

    /**
     * 开始刷新
     * 刷新回调函数，用户在这里写自己的刷新功能实现，处理业务数据的刷新
     *
     * @param layout
     */
    void onRefreshBegin(SwipeFrameLayout layout);

}
