package dc.android.libs.swipe.listener;


import dc.android.libs.swipe.SwipeFrameLayout;
import dc.android.libs.swipe.indicator.SwipeIndicator;

/**
 * 下拉刷新中UI变化
 * Header监听
 *
 * @author senrsl
 * @ClassName: SwipeUIListener
 * @Package: dc.android.libs.swipe
 * @CreateTime: 2019/8/16 4:05 PM
 */
public interface ISwipeUIListener {

    /**
     * Content 重新回到顶部， Header 消失，整个下拉刷新过程完全结束以后，重置 View
     *
     * @param layout
     */
    void onUIReset(SwipeFrameLayout layout);

    /**
     * 准备刷新，Header 将要出现时调用
     *
     * @param layout
     */
    void onUIRefreshPrepare(SwipeFrameLayout layout);

    /**
     * 开始刷新，Header 进入刷新状态之前调用
     *
     * @param layout
     */
    void onUIRefreshBegin(SwipeFrameLayout layout);

    /**
     * 刷新结束，Header 开始向上移动之前调用
     *
     * @param layout
     */
    void onUIRefreshComplete(SwipeFrameLayout layout);

    /**
     * 下拉过程中位置变化回调
     *
     * @param layout
     * @param isUnderTouch
     * @param status
     * @param indicator
     */
    void onUIPositionChange(SwipeFrameLayout layout, boolean isUnderTouch, byte status, SwipeIndicator indicator);

}
