package dc.android.env

import dc.android.env.utils.ExtUtils
import dc.android.env.utils.FixedUtils

/**
 * support config
 *
 * @ClassName: Config
 * @author senrsl
 *
 * @Package: dc.test.groovy
 * @CreateTime: 2020/7/17 5:17 PM
 */
class Config {

    static compileSdkVersion = 28
    static buildToolsVersion = "28.0.3"
    static minSdkVersion = 19
    static targetSdkVersion = 28

    //Version
    static supportLibrary = "28.0.0"
    static coreVersion = "1.0.8"
    static bridgeVersion = "1.0.15"

    static depes = [
            v7        : "com.android.support:appcompat-v7:${supportLibrary}",
            constraint: "com.android.support.constraint:constraint-layout:1.1.0",
    ]

    static tis = [
            "junit": "junit:junit:4.12",
    ]

    static atis = [
            "test"    : "com.android.support.test:runner:1.0.2",
            "espresso": "com.android.support.test.espresso:espresso-core:3.0.2",
    ]

    static runs = [
    ]

    static keys = [
    ]

    static depes3 = [
            core        : "dc.android:core:$coreVersion",
            bridge      : "dc.android:bridge:$bridgeVersion",
            recyclerview: "com.android.support:recyclerview-v7:$supportLibrary"
    ]

    //******* 全体都有
    static testFixed = FixedUtils.&testFixed
    static fixedManifest = FixedUtils.&fixedManifest
    static fixedManifest5 = FixedUtils.&fixedManifest5

    static gets = "\"" + ExtUtils.getsInfo() + "\""

}
