package dc.android.env.utils

import dc.android.env.ConfigKt
import dc.android.env.ConfigX
import org.gradle.api.Project

/**
 *
 *
 * @ClassName: DependUtils
 * @author senrsl
 *
 * @Package: dc.android.env.utils
 * @CreateTime: 2021/3/3 5:02 PM
 */
class DependUtils {

    //Config Df depends
    static void addDepends(Project project) {
        //停止维护support
    }

    //ConfigX Df depends
    static void addXDepends(Project project) {
        //默认依赖项
        project.dependencies {
            implementation project.fileTree(include: ['*.jar', '*.aar'], dir: 'libs')
            ConfigX.depes.each { k, v -> implementation v }
            ConfigX.tis.each { k, v -> testImplementation v }
            ConfigX.atis.each { k, v -> androidTestImplementation v }

            //这里只增加上面主要四项，其他的不要在这里添加
            //project是 编译的主项目，如app; project.rootProject为根项目
//            System.out.println("deps:"+project.rootProject.gradle.gradleVersion)
//            System.out.println("deps:"+project.rootProject.buildscript.properties)
            //需要 android gradle tools > 4.0 支持
            //coreLibraryDesugaring
        }
    }

    //ConfigKt Df depends
    static void addKtDepends(Project project) {

        addXDepends(project)

        //默认依赖项
        project.dependencies {
            ConfigKt.depes.each { k, v -> implementation v }
        }
    }

}
