package dc.android.env.utils

import groovy.xml.XmlUtil

/**
 * 原 fixed.gradle
 *
 * @ClassName: FixedUtils
 * @author senrsl
 *
 * @Package: dc.android.env.utils
 * @CreateTime: 2021/3/3 4:26 PM
 */
class FixedUtils {

    def static fixedActivity(file) {
//        manifest().attributes.each { it -> println(it) }
//        manifest().properties.each { it -> println(it) }

        //def file = new File("${projectDir}/src/main/AndroidManifest.xml")
        def xml = new XmlParser(false, false).parse(file)
        xml.application[0].each { node ->
            if (node.name() == 'activity') {
                println(node.toString())
                //node.attributes.each{attr -> println(attr.toString())}
                println(node.attributes())
                //&& !node.toString().contains("android:screenOrientation")
                def attrStr = node.attributes().toString()

                if (!attrStr.contains("android:theme")   //兼容 8
                        && !attrStr.contains("android:screenOrientation")) {
                    node.attributes().put('android:screenOrientation', 'portrait')
                }

                if (!attrStr.contains("android:theme")   //兼容 7
                        && !attrStr.contains("android:configChanges")) {
                    node.attributes().put('android:configChanges', 'screenLayout|screenSize|smallestScreenSize|orientation')
                }

            }
        }
        file.write(XmlUtil.serialize(xml))
    }


    def static fixedManifest(variant) {
        variant.outputs.each { output ->
            output.processManifest.doLast {
                def outputDirectory = output.processManifest.manifestOutputDirectory
                File manifestOutFile = new File(outputDirectory, 'AndroidManifest.xml')
                if (manifestOutFile.exists()) {

                    fixedActivity(manifestOutFile)

                }
            }
        }
    }

    //Here is the newer variant for Gradle 5.4.1 and Grudle plugin 3.5.1
    def static fixedManifest5(variant) {
        variant.outputs.each { output ->
            def processManifest = output.getProcessManifestProvider().get()
            processManifest.doLast { task ->
                def outputDir = task.getManifestOutputDirectory()
                File outputDirectory
                if (outputDir instanceof File) {
                    outputDirectory = outputDir
                } else {
                    outputDirectory = outputDir.get().asFile
                }
                File manifestOutFile = new File("$outputDirectory/AndroidManifest.xml")

                if (manifestOutFile.exists() && manifestOutFile.canRead() && manifestOutFile.canWrite()) {
                    fixedActivity(manifestOutFile)
                }

            }
        }
    }

    def static testFixed() {
        println("test fixed....")
    }
}

