package dc.android.env

import dc.android.env.utils.ExtUtils
import dc.android.env.utils.FixedUtils

/**
 * AndroidX config
 *
 * @ClassName: ConfigAndroidX
 * @author senrsl
 *
 * @Package: dc.android.env
 * @CreateTime: 2020/7/24 5:42 PM
 */
class ConfigX {

    static compileSdkVersion = 29
    static buildToolsVersion = "29.0.3"
    static minSdkVersion = 19
    static targetSdkVersion = 29
    static abiFilters = "armeabi"

    static aider = [
            suffix     : ".debug",
            PKG_DEBUG  : "",
            PKG_RELEASE: "",
    ]

    //Version
    static supportLibrary = "1.3.1"
    static coreVersion = "1.1.10"
    static bridgeVersion = "1.1.26"
    static constraintVersion = "2.0.4"
    static recyclerVersion = "1.2.1"
    static materialVersion = "1.4.0"
    static swipeVersion = "1.1.0"

    static depes = [
            "v7"         : "androidx.appcompat:appcompat:${supportLibrary}",
            "constraint" : "androidx.constraintlayout:constraintlayout:${constraintVersion}",
            "struct_core": "ml.dcjz:core:${coreVersion}",
    ]

    static tis = [
            "junit": "junit:junit:4.12",
    ]

    static atis = [
            "test"    : "androidx.test:runner:1.2.0",
            "espresso": "androidx.test.espresso:espresso-core:3.2.0",
    ]

    static runs = [
            "REPORT_DEBUG"  : "false",
            "REPORT_RELEASE": "true",
            "buildTime"     : "\"" + new Date().format("yyyy-MM-dd HH:mm:ss") + "\"",
    ]

    static keys = [
    ]

    static depes2 = [
            bridge      : "ml.dcjz:bridge:$bridgeVersion",
            shell       : "ml.dcjz:shell:latest.integration",
            logger      : "ml.dcjz.common:logger:latest.integration",
            recyclerview: "androidx.recyclerview:recyclerview:$recyclerVersion",
            material    : "com.google.android.material:material:$materialVersion",
            swipe       : "androidx.swiperefreshlayout:swiperefreshlayout:$swipeVersion",

            room        : "",
            multidex    : "androidx.multidex:multidex:2.0.1",

            desugaring  : 'com.android.tools:desugar_jdk_libs:1.1.5',

    ]

    //third-party
    static glideVersion = "4.11.0"
    static depes3 = [
            rxjava               : "",
            rxandroid            : "",

            retrofit2            : "com.squareup.retrofit2:retrofit:2.4.0",
            okhttp               : "com.squareup.okhttp3:okhttp:3.10.0",
            gsonConvert          : "",

            dagger               : "com.google.dagger:dagger:2.21",
            daggerAnnotation     : "com.google.dagger:dagger-compiler:2.21",
            gson                 : "com.google.code.gson:gson:2.8.5",
            butterknife          : "com.jakewharton:butterknife:9.0.0-rc1",
            butterknifeAnnotation: "com.jakewharton:butterknife-compiler:9.0.0-rc1",


            adapter              : "ml.dcjz.bridge:adapter:1.1.3",
            permission           : "ml.dcjz.libs:permission:1.1.8",
            net                  : "ml.dcjz.common:net:latest.release",
            swipe                : "ml.dcjz.libs:swipe:latest.release",
            banner               : "ml.dcjz.libs:banner:latest.release",
            browser              : "ml.dcjz.libs:browser:latest.release",

            glide                : "com.github.bumptech.glide:glide:${glideVersion}",
            glideAnnotation      : "com.github.bumptech.glide:compiler:${glideVersion}",
            glideOkhttp          : "com.github.bumptech.glide:okhttp3-integration:${glideVersion}",
            glideRecyclerview    : "com.github.bumptech.glide:recyclerview-integration:${glideVersion}",

            jpush                : "cn.jiguang.sdk:jpush:3.3.2",
            jcore                : "cn.jiguang.sdk:jcore:2.0.1",


            alipay               : "",
            talkingData          : "",
            tbs                  : "com.tencent.tbs.tbssdk:sdk:43939",
            buglyCrash           : "",


            amapLbs              : "com.amap.api:location:4.7.2",
            amapMap              : "",
            baiduLbs             : "",
            baiduMap             : "",

    ]

    //for self
    static depes4 = [

            scheme   : "",
            stat     : "",
            push     : "",

            netDebug : "",
            net      : "",
            paysDebug: "",
            pays     : "",
            lbsDebug : "",
            lbs      : "",
            mapDebug : "",
            map      : "",
            ossDebug : "",
            oss      : "",
            picDebug : "",
            pic      : "",

    ]

    //******* 全体都有
    static testFixed = FixedUtils.&testFixed
    static fixedManifest = FixedUtils.&fixedManifest
    static fixedManifest5 = FixedUtils.&fixedManifest5

    static gets = "\"" + ExtUtils.getsInfo() + "\""

}
