package dc.android.shell;

import java.lang.reflect.Field;

import android.app.Activity;
import dc.android.common.BaseApplication;
import dc.android.shell.listener.ShellActivityLifecycleCallbacks;

/**
 * @author senrsl
 * @ClassName: ShellApplication
 * @Package: com.tinfinite.shell
 * @CreateTime: 2018/10/16 上午10:37
 */
public class ShellApplication extends BaseApplication {

    protected static ShellActivityLifecycleCallbacks lifecycleCallbacks;

    public static Activity getLastActivity() {
        return lifecycleCallbacks.getLastActivity();
    }

    @Override
    public void onCreate() {
        super.onCreate();
        if (!ShellContext.isDebug) antiXposedInject();
    }

    /**
     * 没有类，没有参说明没有xposed注入，但是如果setAccess失败，说明xposed注入了，但我们修改失败了
     */
    private void antiXposedInject() {
        Field xpdisableHooks;
        try {
            xpdisableHooks = ClassLoader.getSystemClassLoader()
                    .loadClass(ShellContext.CLS_XPOSED)
                    .getDeclaredField(ShellContext.XPOSED_DIS);
            xpdisableHooks.setAccessible(true);
            xpdisableHooks.set(null, Boolean.TRUE);
        } catch (NoSuchFieldException e) {
        } catch (ClassNotFoundException e) {
        } catch (IllegalAccessException e) {
            System.exit(1);
        }
    }

}
