package dc.android.shell.listener;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import dc.common.Logger;

/**
 * @author senrsl
 * @ClassName: ShellActivityLifecycleCallbacks
 * @Package: dc.android.shell.listener
 * @CreateTime: 2020/5/8 4:08 PM
 */
public class ShellActivityLifecycleCallbacks implements Application.ActivityLifecycleCallbacks {

    private Activity lastActivity;

    public Activity getLastActivity() {
        return lastActivity;
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        Logger.w(getClass().getSimpleName(), activity, savedInstanceState, lastActivity);
    }

    @Override
    public void onActivityStarted(Activity activity) {

    }

    @Override
    public void onActivityResumed(Activity activity) {
        lastActivity = activity;
    }

    @Override
    public void onActivityPaused(Activity activity) {

    }

    @Override
    public void onActivityStopped(Activity activity) {

    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {

    }

    @Override
    public void onActivityDestroyed(Activity activity) {

    }
}
