/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java.example;

import java.util.HashMap;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoost;
import ml.dmlc.xgboost4j.java.XGBoostError;

public class BoostFromPrediction {
    public static void main(String[] args) throws XGBoostError {
        System.out.println("start running example to start from a initial prediction");
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("eta", 1.0);
        params.put("max_depth", 2);
        params.put("silent", 1);
        params.put("objective", "binary:logistic");
        HashMap<String, DMatrix> watches = new HashMap<String, DMatrix>();
        watches.put("train", trainMat);
        watches.put("test", testMat);
        Booster booster = XGBoost.train((DMatrix)trainMat, params, (int)1, watches, null, null);
        float[][] trainPred = booster.predict(trainMat, true);
        float[][] testPred = booster.predict(testMat, true);
        trainMat.setBaseMargin(trainPred);
        testMat.setBaseMargin(testPred);
        System.out.println("result of running from initial prediction");
        Booster booster2 = XGBoost.train((DMatrix)trainMat, params, (int)1, watches, null, null);
    }
}

