/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java.example;

import java.util.HashMap;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.XGBoost;
import ml.dmlc.xgboost4j.java.XGBoostError;
import ml.dmlc.xgboost4j.java.example.util.CustomEval;

public class PredictFirstNtree {
    public static void main(String[] args) throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("eta", 1.0);
        params.put("max_depth", 2);
        params.put("silent", 1);
        params.put("objective", "binary:logistic");
        HashMap<String, DMatrix> watches = new HashMap<String, DMatrix>();
        watches.put("train", trainMat);
        watches.put("test", testMat);
        int round = 3;
        Booster booster = XGBoost.train((DMatrix)trainMat, params, (int)round, watches, null, null);
        float[][] predicts1 = booster.predict(testMat, false, 1);
        float[][] predicts2 = booster.predict(testMat);
        CustomEval eval2 = new CustomEval();
        System.out.println("error of predicts1: " + eval2.eval(predicts1, testMat));
        System.out.println("error of predicts2: " + eval2.eval(predicts2, testMat));
    }
}

