/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.scala.example.spark;

import ml.dmlc.xgboost4j.scala.example.spark.SalesRecord;
import ml.dmlc.xgboost4j.scala.example.spark.SparkModelTuningTool$;
import ml.dmlc.xgboost4j.scala.example.spark.Store;
import ml.dmlc.xgboost4j.scala.spark.XGBoostEstimator;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.feature.StringIndexer;
import org.apache.spark.ml.feature.VectorAssembler;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.tuning.ParamGridBuilder;
import org.apache.spark.ml.tuning.TrainValidationSplit;
import org.apache.spark.ml.tuning.TrainValidationSplitModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple10;
import scala.Tuple13;
import scala.Tuple9;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkModelTuningTool$ {
    public static final SparkModelTuningTool$ MODULE$;

    static {
        new SparkModelTuningTool$();
    }

    private List<Store> parseStoreFile(String storeFilePath) {
        BooleanRef isHeader = BooleanRef.create((boolean)true);
        ListBuffer storeInstances = new ListBuffer();
        Source$.MODULE$.fromFile(storeFilePath, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(isHeader, storeInstances){
            public static final long serialVersionUID = 0L;
            private final BooleanRef isHeader$1;
            private final ListBuffer storeInstances$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(String line) {
                BoxedUnit boxedUnit;
                if (this.isHeader$1.elem) {
                    this.isHeader$1.elem = false;
                    boxedUnit = BoxedUnit.UNIT;
                    return boxedUnit;
                }
                try {
                    String[] strArray = line.split(",");
                    if (strArray.length == 10) {
                        Tuple10 tuple10;
                        String[] stringArray = line.split(",");
                        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(10) != 0) throw new MatchError((Object)stringArray);
                        String storeIdStr = (String)((SeqLike)option.get()).apply(0);
                        String storeTypeStr = (String)((SeqLike)option.get()).apply(1);
                        String assortmentStr = (String)((SeqLike)option.get()).apply(2);
                        String competitionDistanceStr = (String)((SeqLike)option.get()).apply(3);
                        String competitionOpenSinceMonthStr = (String)((SeqLike)option.get()).apply(4);
                        String competitionOpenSinceYearStr = (String)((SeqLike)option.get()).apply(5);
                        String promo2Str = (String)((SeqLike)option.get()).apply(6);
                        String promo2SinceWeekStr = (String)((SeqLike)option.get()).apply(7);
                        String promo2SinceYearStr = (String)((SeqLike)option.get()).apply(8);
                        String promoIntervalStr = (String)((SeqLike)option.get()).apply(9);
                        Tuple10 tuple102 = tuple10 = new Tuple10((Object)storeIdStr, (Object)storeTypeStr, (Object)assortmentStr, (Object)competitionDistanceStr, (Object)competitionOpenSinceMonthStr, (Object)competitionOpenSinceYearStr, (Object)promo2Str, (Object)promo2SinceWeekStr, (Object)promo2SinceYearStr, (Object)promoIntervalStr);
                        String storeIdStr2 = (String)tuple102._1();
                        String storeTypeStr2 = (String)tuple102._2();
                        String assortmentStr2 = (String)tuple102._3();
                        String competitionDistanceStr2 = (String)tuple102._4();
                        String competitionOpenSinceMonthStr2 = (String)tuple102._5();
                        String competitionOpenSinceYearStr2 = (String)tuple102._6();
                        String promo2Str2 = (String)tuple102._7();
                        String promo2SinceWeekStr2 = (String)tuple102._8();
                        String promo2SinceYearStr2 = (String)tuple102._9();
                        String promoIntervalStr2 = (String)tuple102._10();
                        String string = competitionDistanceStr2;
                        String string2 = "";
                        String string3 = competitionOpenSinceMonthStr2;
                        String string4 = "";
                        String string5 = competitionOpenSinceYearStr2;
                        String string6 = "";
                        String string7 = promo2Str2;
                        String string8 = "0";
                        String string9 = promo2Str2;
                        String string10 = "0";
                        boxedUnit = this.storeInstances$1.$plus$eq((Object)new Store(new StringOps(Predef$.MODULE$.augmentString(storeIdStr2)).toInt(), storeTypeStr2, assortmentStr2, !(string != null ? !string.equals(string2) : string2 != null) ? -1 : new StringOps(Predef$.MODULE$.augmentString(competitionDistanceStr2)).toInt(), !(string3 != null ? !string3.equals(string4) : string4 != null) ? -1 : new StringOps(Predef$.MODULE$.augmentString(competitionOpenSinceMonthStr2)).toInt(), !(string5 != null ? !string5.equals(string6) : string6 != null) ? -1 : new StringOps(Predef$.MODULE$.augmentString(competitionOpenSinceYearStr2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(promo2Str2)).toInt(), !(string7 != null ? !string7.equals(string8) : string8 != null) ? -1 : new StringOps(Predef$.MODULE$.augmentString(promo2SinceWeekStr2)).toInt(), !(string9 != null ? !string9.equals(string10) : string10 != null) ? -1 : new StringOps(Predef$.MODULE$.augmentString(promo2SinceYearStr2)).toInt(), promoIntervalStr2.replace("\"", "")));
                        return boxedUnit;
                    } else {
                        Tuple13 tuple13;
                        String[] stringArray = line.split(",");
                        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(13) != 0) throw new MatchError((Object)stringArray);
                        String storeIdStr = (String)((SeqLike)option.get()).apply(0);
                        String storeTypeStr = (String)((SeqLike)option.get()).apply(1);
                        String assortmentStr = (String)((SeqLike)option.get()).apply(2);
                        String competitionDistanceStr = (String)((SeqLike)option.get()).apply(3);
                        String competitionOpenSinceMonthStr = (String)((SeqLike)option.get()).apply(4);
                        String competitionOpenSinceYearStr = (String)((SeqLike)option.get()).apply(5);
                        String promo2Str = (String)((SeqLike)option.get()).apply(6);
                        String promo2SinceWeekStr = (String)((SeqLike)option.get()).apply(7);
                        String promo2SinceYearStr = (String)((SeqLike)option.get()).apply(8);
                        String firstMonth = (String)((SeqLike)option.get()).apply(9);
                        String secondMonth = (String)((SeqLike)option.get()).apply(10);
                        String thirdMonth = (String)((SeqLike)option.get()).apply(11);
                        String forthMonth = (String)((SeqLike)option.get()).apply(12);
                        Tuple13 tuple132 = tuple13 = new Tuple13((Object)storeIdStr, (Object)storeTypeStr, (Object)assortmentStr, (Object)competitionDistanceStr, (Object)competitionOpenSinceMonthStr, (Object)competitionOpenSinceYearStr, (Object)promo2Str, (Object)promo2SinceWeekStr, (Object)promo2SinceYearStr, (Object)firstMonth, (Object)secondMonth, (Object)thirdMonth, (Object)forthMonth);
                        String storeIdStr3 = (String)tuple132._1();
                        String storeTypeStr3 = (String)tuple132._2();
                        String assortmentStr3 = (String)tuple132._3();
                        String competitionDistanceStr3 = (String)tuple132._4();
                        String competitionOpenSinceMonthStr3 = (String)tuple132._5();
                        String competitionOpenSinceYearStr3 = (String)tuple132._6();
                        String promo2Str3 = (String)tuple132._7();
                        String promo2SinceWeekStr3 = (String)tuple132._8();
                        String promo2SinceYearStr3 = (String)tuple132._9();
                        String firstMonth2 = (String)tuple132._10();
                        String secondMonth2 = (String)tuple132._11();
                        String thirdMonth2 = (String)tuple132._12();
                        String forthMonth2 = (String)tuple132._13();
                        String string = competitionDistanceStr3;
                        String string11 = "";
                        String string12 = competitionOpenSinceMonthStr3;
                        String string13 = "";
                        String string14 = competitionOpenSinceYearStr3;
                        String string15 = "";
                        String string16 = promo2Str3;
                        String string17 = "0";
                        String string18 = promo2Str3;
                        String string19 = "0";
                        boxedUnit = this.storeInstances$1.$plus$eq((Object)new Store(new StringOps(Predef$.MODULE$.augmentString(storeIdStr3)).toInt(), storeTypeStr3, assortmentStr3, !(string != null ? !string.equals(string11) : string11 != null) ? -1 : new StringOps(Predef$.MODULE$.augmentString(competitionDistanceStr3)).toInt(), !(string12 != null ? !string12.equals(string13) : string13 != null) ? -1 : new StringOps(Predef$.MODULE$.augmentString(competitionOpenSinceMonthStr3)).toInt(), !(string14 != null ? !string14.equals(string15) : string15 != null) ? -1 : new StringOps(Predef$.MODULE$.augmentString(competitionOpenSinceYearStr3)).toInt(), new StringOps(Predef$.MODULE$.augmentString(promo2Str3)).toInt(), !(string16 != null ? !string16.equals(string17) : string17 != null) ? -1 : new StringOps(Predef$.MODULE$.augmentString(promo2SinceWeekStr3)).toInt(), !(string18 != null ? !string18.equals(string19) : string19 != null) ? -1 : new StringOps(Predef$.MODULE$.augmentString(promo2SinceYearStr3)).toInt(), new StringBuilder().append((Object)firstMonth2.replace("\"", "")).append((Object)",").append((Object)secondMonth2).append((Object)",").append((Object)thirdMonth2).append((Object)",").append((Object)forthMonth2.replace("\"", "")).toString()));
                    }
                    return boxedUnit;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw scala.sys.package$.MODULE$.exit(1);
                }
            }
            {
                this.isHeader$1 = isHeader$1;
                this.storeInstances$1 = storeInstances$1;
            }
        });
        return storeInstances.toList();
    }

    private List<SalesRecord> parseTrainingFile(String trainingPath) {
        BooleanRef isHeader = BooleanRef.create((boolean)true);
        ListBuffer records = new ListBuffer();
        Source$.MODULE$.fromFile(trainingPath, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(isHeader, records){
            public static final long serialVersionUID = 0L;
            private final BooleanRef isHeader$2;
            private final ListBuffer records$1;

            public final Object apply(String line) {
                String[] stringArray;
                block4: {
                    BoxedUnit boxedUnit;
                    block3: {
                        Tuple9 tuple9;
                        block2: {
                            if (!this.isHeader$2.elem) break block2;
                            this.isHeader$2.elem = false;
                            boxedUnit = BoxedUnit.UNIT;
                            break block3;
                        }
                        stringArray = line.split(",");
                        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
                        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(9) != 0) break block4;
                        String storeIdStr = (String)((SeqLike)option.get()).apply(0);
                        String daysOfWeekStr = (String)((SeqLike)option.get()).apply(1);
                        String dateStr = (String)((SeqLike)option.get()).apply(2);
                        String salesStr = (String)((SeqLike)option.get()).apply(3);
                        String customerStr = (String)((SeqLike)option.get()).apply(4);
                        String openStr = (String)((SeqLike)option.get()).apply(5);
                        String promoStr = (String)((SeqLike)option.get()).apply(6);
                        String stateHolidayStr = (String)((SeqLike)option.get()).apply(7);
                        String schoolHolidayStr = (String)((SeqLike)option.get()).apply(8);
                        Tuple9 tuple92 = tuple9 = new Tuple9((Object)storeIdStr, (Object)daysOfWeekStr, (Object)dateStr, (Object)salesStr, (Object)customerStr, (Object)openStr, (Object)promoStr, (Object)stateHolidayStr, (Object)schoolHolidayStr);
                        String storeIdStr2 = (String)tuple92._1();
                        String daysOfWeekStr2 = (String)tuple92._2();
                        String dateStr2 = (String)tuple92._3();
                        String salesStr2 = (String)tuple92._4();
                        String customerStr2 = (String)tuple92._5();
                        String openStr2 = (String)tuple92._6();
                        String promoStr2 = (String)tuple92._7();
                        String stateHolidayStr2 = (String)tuple92._8();
                        String schoolHolidayStr2 = (String)tuple92._9();
                        SalesRecord salesRecord = new SalesRecord(new StringOps(Predef$.MODULE$.augmentString(storeIdStr2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(daysOfWeekStr2)).toInt(), dateStr2, new StringOps(Predef$.MODULE$.augmentString(salesStr2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(customerStr2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(openStr2)).toInt(), new StringOps(Predef$.MODULE$.augmentString(promoStr2)).toInt(), stateHolidayStr2, schoolHolidayStr2);
                        boxedUnit = this.records$1.$plus$eq((Object)salesRecord);
                    }
                    return boxedUnit;
                }
                throw new MatchError((Object)stringArray);
            }
            {
                this.isHeader$2 = isHeader$2;
                this.records$1 = records$1;
            }
        });
        return records.toList();
    }

    private Dataset<Row> featureEngineering(Dataset<Row> ds) {
        StringIndexer stateHolidayIndexer = new StringIndexer().setInputCol("stateHoliday").setOutputCol("stateHolidayIndex");
        StringIndexer schoolHolidayIndexer = new StringIndexer().setInputCol("schoolHoliday").setOutputCol("schoolHolidayIndex");
        StringIndexer storeTypeIndexer = new StringIndexer().setInputCol("storeType").setOutputCol("storeTypeIndex");
        StringIndexer assortmentIndexer = new StringIndexer().setInputCol("assortment").setOutputCol("assortmentIndex");
        StringIndexer promoInterval = new StringIndexer().setInputCol("promoInterval").setOutputCol("promoIntervalIndex");
        Dataset filteredDS = ds.filter(ds.sparkSession().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sales"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)0))).filter(ds.sparkSession().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"open"}))).$((Seq)Nil$.MODULE$).$greater((Object)BoxesRunTime.boxToInteger((int)0)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator1$1() {
            }
        }
        Dataset dsWithDayCol = filteredDS.withColumn("day", functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String dateStr) {
                return new StringOps(Predef$.MODULE$.augmentString(dateStr.split("-")[2])).toInt();
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator1$1())).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("date")})));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator2$1() {
            }
        }
        Dataset dsWithMonthCol = dsWithDayCol.withColumn("month", functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String dateStr) {
                return new StringOps(Predef$.MODULE$.augmentString(dateStr.split("-")[1])).toInt();
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator2$1())).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("date")})));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator3$1() {
            }
        }
        Dataset dsWithYearCol = dsWithMonthCol.withColumn("year", functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String dateStr) {
                return new StringOps(Predef$.MODULE$.augmentString(dateStr.split("-")[0])).toInt();
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Int(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator3$1())).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("date")})));
        Dataset dsWithLogSales = dsWithYearCol.withColumn("logSales", functions$.MODULE$.udf((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int sales) {
                return this.apply$mcDI$sp(sales);
            }

            public double apply$mcDI$sp(int sales) {
                return scala.math.package$.MODULE$.log((double)sales);
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int()).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("sales")})));
        double meanCompetitionDistance = BoxesRunTime.unboxToDouble((Object)((Row)dsWithLogSales.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.avg("competitionDistance")})).first()).apply(0));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"====").append((Object)BoxesRunTime.boxToDouble((double)meanCompetitionDistance)).toString());
        Dataset finalDS = dsWithLogSales.withColumn("transformedCompetitionDistance", functions$.MODULE$.udf((Function1)new Serializable(meanCompetitionDistance){
            public static final long serialVersionUID = 0L;
            private final double meanCompetitionDistance$1;

            public final double apply(int distance) {
                return this.apply$mcDI$sp(distance);
            }

            public double apply$mcDI$sp(int distance) {
                return distance > 0 ? (double)distance : this.meanCompetitionDistance$1;
            }
            {
                this.meanCompetitionDistance$1 = meanCompetitionDistance$1;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int()).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("competitionDistance")})));
        VectorAssembler vectorAssembler = new VectorAssembler().setInputCols((String[])((Object[])new String[]{"storeId", "daysOfWeek", "promo", "competitionDistance", "promo2", "day", "month", "year", "transformedCompetitionDistance", "stateHolidayIndex", "schoolHolidayIndex", "storeTypeIndex", "assortmentIndex", "promoIntervalIndex"})).setOutputCol("features");
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{stateHolidayIndexer, schoolHolidayIndexer, storeTypeIndexer, assortmentIndexer, promoInterval, vectorAssembler}));
        return pipeline.fit(finalDS).transform(finalDS).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"stateHoliday", "schoolHoliday", "storeType", "assortment", "promoInterval", "sales", "promo2SinceWeek", "customers", "promoInterval", "competitionOpenSinceYear", "competitionOpenSinceMonth", "promo2SinceYear", "competitionDistance", "date"}));
    }

    private TrainValidationSplitModel crossValidation(Map<String, Object> xgboostParam, Dataset<?> trainingData) {
        XGBoostEstimator xgbEstimator = (XGBoostEstimator)new XGBoostEstimator(xgboostParam).setFeaturesCol("features").setLabelCol("logSales");
        ParamMap[] paramGrid = new ParamGridBuilder().addGrid(xgbEstimator.round(), new int[]{20, 50}).addGrid(xgbEstimator.eta(), new double[]{0.1, 0.4}).build();
        TrainValidationSplit tv = new TrainValidationSplit().setEstimator((Estimator)xgbEstimator).setEvaluator((Evaluator)new RegressionEvaluator().setLabelCol("logSales")).setEstimatorParamMaps(paramGrid).setTrainRatio(0.8);
        return tv.fit(trainingData);
    }

    public void main(String[] args) {
        SparkSession sparkSession = SparkSession$.MODULE$.builder().appName("rosseman").getOrCreate();
        String trainingPath = args[0];
        List<SalesRecord> allSalesRecords = this.parseTrainingFile(trainingPath);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator8$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ml.dmlc.xgboost4j.scala.example.spark.SalesRecord").asType().toTypeConstructor();
            }

            public Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator8$1() {
            }
        }
        Dataset salesRecordsDF = sparkSession.implicits().localSeqToDatasetHolder(allSalesRecords, sparkSession.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator8$1()))).toDF();
        String storeFilePath = args[1];
        List<Store> allStores = this.parseStoreFile(storeFilePath);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator16$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("ml.dmlc.xgboost4j.scala.example.spark.Store").asType().toTypeConstructor();
            }

            public Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator16$1() {
            }
        }
        Dataset storesDS = sparkSession.implicits().localSeqToDatasetHolder(allStores, sparkSession.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Ml_dmlc_xgboost4j_scala_example_spark_SparkModelTuningTool$$typecreator16$1()))).toDF();
        Dataset fullDataset = salesRecordsDF.join(storesDS, "storeId");
        Dataset<Row> featureEngineeredDF = this.featureEngineering((Dataset<Row>)fullDataset);
        HashMap params = new HashMap();
        params.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"eta"), (Object)BoxesRunTime.boxToDouble((double)0.1)));
        params.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_depth"), (Object)BoxesRunTime.boxToInteger((int)6)));
        params.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"silent"), (Object)BoxesRunTime.boxToInteger((int)1)));
        params.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ntreelimit"), (Object)BoxesRunTime.boxToInteger((int)1000)));
        params.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objective"), (Object)"reg:linear"));
        params.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subsample"), (Object)BoxesRunTime.boxToDouble((double)0.8)));
        params.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"num_round"), (Object)BoxesRunTime.boxToInteger((int)100)));
        TrainValidationSplitModel bestModel = this.crossValidation((Map<String, Object>)params.toMap(Predef$.MODULE$.$conforms()), featureEngineeredDF);
    }

    private SparkModelTuningTool$() {
        MODULE$ = this;
    }
}

