/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.scala.example.spark;

import ml.dmlc.xgboost4j.scala.Booster;
import ml.dmlc.xgboost4j.scala.EvalTrait;
import ml.dmlc.xgboost4j.scala.ObjectiveTrait;
import ml.dmlc.xgboost4j.scala.spark.XGBoost$;
import ml.dmlc.xgboost4j.scala.spark.XGBoostModel;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class SparkWithRDD$ {
    public static final SparkWithRDD$ MODULE$;

    static {
        new SparkWithRDD$();
    }

    public void main(String[] args) {
        if (args.length != 5) {
            Predef$.MODULE$.println((Object)"usage: program num_of_rounds num_workers training_path test_path model_path");
            throw package$.MODULE$.exit(1);
        }
        SparkConf sparkConf = new SparkConf().setAppName("XGBoost-spark-example").set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        sparkConf.registerKryoClasses((Class[])((Object[])new Class[]{Booster.class}));
        SparkContext sc = new SparkContext(sparkConf);
        String inputTrainPath = args[2];
        String inputTestPath = args[3];
        String outputModelPath = args[4];
        int numRound = new StringOps(Predef$.MODULE$.augmentString(args[0])).toInt();
        RDD trainRDD = MLUtils$.MODULE$.loadLibSVMFile(sc, inputTrainPath).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final org.apache.spark.ml.feature.LabeledPoint apply(LabeledPoint lp) {
                return new org.apache.spark.ml.feature.LabeledPoint(lp.label(), (Vector)new DenseVector(lp.features().toArray()));
            }
        }, ClassTag$.MODULE$.apply(org.apache.spark.ml.feature.LabeledPoint.class));
        RDD testSet = MLUtils$.MODULE$.loadLibSVMFile(sc, inputTestPath).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DenseVector apply(LabeledPoint lp) {
                return new DenseVector(lp.features().toArray());
            }
        }, ClassTag$.MODULE$.apply(DenseVector.class));
        Map paramMap = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"eta"), (Object)BoxesRunTime.boxToFloat((float)0.1f)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max_depth"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"objective"), (Object)"binary:logistic")})).toMap(Predef$.MODULE$.$conforms());
        RDD x$1 = trainRDD;
        Map x$2 = paramMap;
        int x$3 = numRound;
        int x$4 = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        boolean x$5 = true;
        ObjectiveTrait x$6 = XGBoost$.MODULE$.trainWithRDD$default$5();
        EvalTrait x$7 = XGBoost$.MODULE$.trainWithRDD$default$6();
        float x$8 = XGBoost$.MODULE$.trainWithRDD$default$8();
        XGBoostModel xgboostModel = XGBoost$.MODULE$.trainWithRDD(x$1, x$2, x$3, x$4, x$6, x$7, x$5, x$8);
        xgboostModel.predict(testSet, Float.NaN);
        xgboostModel.saveModelAsHadoopFile(outputModelPath, sc);
    }

    private SparkWithRDD$() {
        MODULE$ = this;
    }
}

