/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java.example.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public class DataLoader {
    public static DenseData loadCSVFile(String filePath) throws IOException {
        String line;
        DenseData denseData = new DenseData();
        File f = new File(filePath);
        FileInputStream in = new FileInputStream(f);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        denseData.nrow = 0;
        denseData.ncol = -1;
        ArrayList<Float> tlabels = new ArrayList<Float>();
        ArrayList<Float> tdata = new ArrayList<Float>();
        while ((line = reader.readLine()) != null) {
            String[] items = line.trim().split(",");
            if (items.length == 0) continue;
            ++denseData.nrow;
            if (denseData.ncol == -1) {
                denseData.ncol = items.length - 1;
            }
            tlabels.add(Float.valueOf(items[items.length - 1]));
            for (int i = 0; i < items.length - 1; ++i) {
                tdata.add(Float.valueOf(items[i]));
            }
        }
        reader.close();
        in.close();
        denseData.labels = ArrayUtils.toPrimitive((Float[])tlabels.toArray(new Float[tlabels.size()]));
        denseData.data = ArrayUtils.toPrimitive((Float[])tdata.toArray(new Float[tdata.size()]));
        return denseData;
    }

    public static CSRSparseData loadSVMFile(String filePath) throws IOException {
        String line;
        CSRSparseData spData = new CSRSparseData();
        ArrayList<Float> tlabels = new ArrayList<Float>();
        ArrayList<Float> tdata = new ArrayList<Float>();
        ArrayList<Long> theaders = new ArrayList<Long>();
        ArrayList<Integer> tindex = new ArrayList<Integer>();
        File f = new File(filePath);
        FileInputStream in = new FileInputStream(f);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, "UTF-8"));
        long rowheader = 0L;
        theaders.add(rowheader);
        while ((line = reader.readLine()) != null) {
            String[] items = line.trim().split(" ");
            if (items.length == 0) continue;
            theaders.add(rowheader += (long)(items.length - 1));
            tlabels.add(Float.valueOf(items[0]));
            for (int i = 1; i < items.length; ++i) {
                String[] tup = items[i].split(":");
                assert (tup.length == 2);
                tdata.add(Float.valueOf(tup[1]));
                tindex.add(Integer.valueOf(tup[0]));
            }
        }
        spData.labels = ArrayUtils.toPrimitive((Float[])tlabels.toArray(new Float[tlabels.size()]));
        spData.data = ArrayUtils.toPrimitive((Float[])tdata.toArray(new Float[tdata.size()]));
        spData.colIndex = ArrayUtils.toPrimitive((Integer[])tindex.toArray(new Integer[tindex.size()]));
        spData.rowHeaders = ArrayUtils.toPrimitive((Long[])theaders.toArray(new Long[theaders.size()]));
        return spData;
    }

    public static class CSRSparseData {
        public float[] labels;
        public float[] data;
        public long[] rowHeaders;
        public int[] colIndex;
    }

    public static class DenseData {
        public float[] labels;
        public float[] data;
        public int nrow;
        public int ncol;
    }
}

