/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java.example.util;

import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.IEvaluation;
import ml.dmlc.xgboost4j.java.XGBoostError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomEval
implements IEvaluation {
    private static final Log logger = LogFactory.getLog(CustomEval.class);
    String evalMetric = "custom_error";

    public String getMetric() {
        return this.evalMetric;
    }

    public float eval(float[][] predicts, DMatrix dmat) {
        float[] labels;
        float error = 0.0f;
        try {
            labels = dmat.getLabel();
        }
        catch (XGBoostError ex) {
            logger.error((Object)ex);
            return -1.0f;
        }
        int nrow = predicts.length;
        for (int i = 0; i < nrow; ++i) {
            if (labels[i] == 0.0f && (double)predicts[i][0] > 0.5) {
                error += 1.0f;
                continue;
            }
            if (labels[i] != 1.0f || !((double)predicts[i][0] <= 0.5)) continue;
            error += 1.0f;
        }
        return error / (float)labels.length;
    }
}

