/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.net.URL;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskFailedListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u0001%\u0011qc\u00159be.\u0004\u0016M]1mY\u0016d\u0017n]7Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!B:qCJ\\'BA\u0003\u0007\u0003\u0019\t\u0007/Y2iK*\tq!A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aD\u0001\"\u0005\u0001\u0003\u0006\u0004%\tAE\u0001\u0003g\u000e,\u0012a\u0005\t\u0003)Ui\u0011AA\u0005\u0003-\t\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IaE\u0001\u0004g\u000e\u0004\u0003\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000fQLW.Z8viB\u00111\u0002H\u0005\u0003;1\u0011A\u0001T8oO\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0005o/>\u00148.\u001a:t!\tY\u0011%\u0003\u0002#\u0019\t\u0019\u0011J\u001c;\t\u000b\u0011\u0002A\u0011A\u0013\u0002\rqJg.\u001b;?)\u00111s\u0005K\u0015\u0011\u0005Q\u0001\u0001\"B\t$\u0001\u0004\u0019\u0002\"\u0002\u000e$\u0001\u0004Y\u0002\"B\u0010$\u0001\u0004\u0001\u0003BB\u0016\u0001A\u0003%A&\u0001\u0004nCB\u0004XM\u001d\t\u0003[Qj\u0011A\f\u0006\u0003_A\n1!\\1q\u0015\t\t$'A\u0004kC\u000e\\7o\u001c8\u000b\u0005M2\u0011\u0001C2pI\u0016D\u0017-^:\n\u0005Ur#\u0001D(cU\u0016\u001cG/T1qa\u0016\u0014\bBB\u001c\u0001A\u0003%\u0001(\u0001\u0004m_\u001e<WM\u001d\t\u0003syj\u0011A\u000f\u0006\u0003wq\nq\u0001\\8hO&twM\u0003\u0002>\t\u000591m\\7n_:\u001c\u0018BA ;\u0005\raun\u001a\u0005\u0007\u0003\u0002\u0001\u000b\u0011\u0002\"\u0002\u0007U\u0014H\u000e\u0005\u0002D\u00116\tAI\u0003\u0002F\r\u0006\u0019a.\u001a;\u000b\u0003\u001d\u000bAA[1wC&\u0011\u0011\n\u0012\u0002\u0004+Jc\u0005BB&\u0001A\u0013%A*A\u0007ok6\fE.\u001b<f\u0007>\u0014Xm]\u000b\u0002A!1a\n\u0001Q\u0005\n=\u000b\u0001c^1ji\u001a{'oQ8oI&$\u0018n\u001c8\u0015\tAK\u0016M\u0019\t\u0004#R3V\"\u0001*\u000b\u0005Mc\u0011AC2p]\u000e,(O]3oi&\u0011QK\u0015\u0002\u0007\rV$XO]3\u0011\u0005-9\u0016B\u0001-\r\u0005\u0011)f.\u001b;\t\rikE\u00111\u0001\\\u0003%\u0019wN\u001c3ji&|g\u000eE\u0002\f9zK!!\u0018\u0007\u0003\u0011q\u0012\u0017P\\1nKz\u0002\"aC0\n\u0005\u0001d!a\u0002\"p_2,\u0017M\u001c\u0005\u000655\u0003\ra\u0007\u0005\bG6\u0003\n\u00111\u0001\u001c\u00035\u0019\u0007.Z2l\u0013:$XM\u001d<bY\"1Q\r\u0001Q\u0005\n\u0019\f1b]1gK\u0016CXmY;uKV\u0011qM\u001b\u000b\u0003QN\u0004\"!\u001b6\r\u0001\u0011)1\u000e\u001ab\u0001Y\n\tA+\u0005\u0002naB\u00111B\\\u0005\u0003_2\u0011qAT8uQ&tw\r\u0005\u0002\fc&\u0011!\u000f\u0004\u0002\u0004\u0003:L\bB\u0002;e\t\u0003\u0007Q/\u0001\u0003c_\u0012L\bcA\u0006]Q\")q\u000f\u0001C\u0001q\u00069Q\r_3dkR,WCA=|)\tQH\u0010\u0005\u0002jw\u0012)1N\u001eb\u0001Y\"1AO\u001eCA\u0002u\u00042a\u0003/{\u0011!y\b!%A\u0005\n\u0005\u0005\u0011AG<bSR4uN]\"p]\u0012LG/[8oI\u0011,g-Y;mi\u0012\u001aTCAA\u0002U\rY\u0012QA\u0016\u0003\u0003\u000f\u0001B!!\u0003\u0002\u00145\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0003\u0007\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0016\u0005-!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class SparkParallelismTracker {
    private final SparkContext sc;
    private final long timeout;
    public final int org$apache$spark$SparkParallelismTracker$$nWorkers;
    private final ObjectMapper mapper;
    private final Log logger;
    private final URL url;

    public SparkContext sc() {
        return this.sc;
    }

    public int org$apache$spark$SparkParallelismTracker$$numAliveCores() {
        int n;
        try {
            n = this.url == null ? Integer.MAX_VALUE : BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.mapper.readTree(this.url).findValues("totalCores")).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(JsonNode x$1) {
                    return x$1.asInt();
                }
            }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        catch (Throwable throwable) {
            this.logger.warn((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to read total number of alive cores from REST API."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Health Check will be ignored."})).s((Seq)Nil$.MODULE$)).toString());
            throwable.printStackTrace();
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    private Future<BoxedUnit> waitForCondition(Function0<Object> condition, long timeout, long checkInterval) {
        Future monitor = Future$.MODULE$.apply((Function0)new Serializable(this, condition, checkInterval){
            public static final long serialVersionUID = 0L;
            private final Function0 condition$1;
            private final long checkInterval$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (!this.condition$1.apply$mcZ$sp()) {
                    Thread.sleep(this.checkInterval$1);
                }
                return;
            }
            {
                this.condition$1 = condition$1;
                this.checkInterval$1 = checkInterval$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        return (Future)Await$.MODULE$.ready((Awaitable)monitor, (Duration)new package.DurationLong(package$.MODULE$.DurationLong(timeout)).millis());
    }

    private long waitForCondition$default$3() {
        return 100L;
    }

    /*
     * WARNING - void declaration
     */
    private <T> T safeExecute(Function0<T> body) {
        Object object;
        TaskFailedListener listener = new TaskFailedListener();
        this.sc().addSparkListener((SparkListenerInterface)listener);
        try {
            object = body.apply();
        }
        catch (Throwable throwable) {
            void var2_2;
            this.sc().listenerBus().removeListener((SparkListenerInterface)var2_2);
            throw throwable;
        }
        this.sc().listenerBus().removeListener((SparkListenerInterface)listener);
        return (T)object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(Function0<T> body) {
        Object object;
        if (this.timeout <= 0L) {
            object = body.apply();
            return (T)object;
        }
        try {
            this.waitForCondition((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkParallelismTracker $outer;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.org$apache$spark$SparkParallelismTracker$$numAliveCores() >= this.$outer.org$apache$spark$SparkParallelismTracker$$nWorkers;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.timeout, this.waitForCondition$default$3());
        }
        catch (TimeoutException timeoutException) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to get ", " workers for XGBoost training"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.org$apache$spark$SparkParallelismTracker$$nWorkers)})));
        }
        object = this.safeExecute(body);
        return (T)object;
    }

    public SparkParallelismTracker(SparkContext sc, long timeout, int nWorkers) {
        URL uRL;
        this.sc = sc;
        this.timeout = timeout;
        this.org$apache$spark$SparkParallelismTracker$$nWorkers = nWorkers;
        this.mapper = new ObjectMapper();
        this.logger = LogFactory.getLog((String)"XGBoostSpark");
        Option option = sc.uiWebUrl();
        if (option instanceof Some) {
            Some some = (Some)option;
            String baseUrl = (String)some.x();
            uRL = new URL(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/api/v1/applications/", "/executors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl, sc.applicationId()})));
        } else {
            uRL = null;
        }
        this.url = uRL;
    }
}

