/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.net.URL;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskFailedListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001%\u0011qc\u00159be.\u0004\u0016M]1mY\u0016d\u0017n]7Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!B:qCJ\\'BA\u0003\u0007\u0003\u0019\t\u0007/Y2iK*\tq!A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aD\u0001\"\u0005\u0001\u0003\u0006\u0004%\tAE\u0001\u0003g\u000e,\u0012a\u0005\t\u0003)Ui\u0011AA\u0005\u0003-\t\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IaE\u0001\u0004g\u000e\u0004\u0003\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000fQLW.Z8viB\u00111\u0002H\u0005\u0003;1\u0011A\u0001T8oO\"Aq\u0004\u0001B\u0001B\u0003%\u0001%\u0001\u0006ok6<vN]6feN\u0004\"aC\u0011\n\u0005\tb!aA%oi\")A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"BAJ\u0014)SA\u0011A\u0003\u0001\u0005\u0006#\r\u0002\ra\u0005\u0005\u00065\r\u0002\ra\u0007\u0005\u0006?\r\u0002\r\u0001\t\u0005\u0007W\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u001dI,\u0017/^3ti\u0016$7i\u001c:fg\"1Q\u0006\u0001Q\u0001\n9\na!\\1qa\u0016\u0014\bCA\u00187\u001b\u0005\u0001$BA\u00193\u0003\ri\u0017\r\u001d\u0006\u0003gQ\nqA[1dWN|gN\u0003\u00026\r\u0005A1m\u001c3fQ\u0006,8/\u0003\u00028a\taqJ\u00196fGRl\u0015\r\u001d9fe\"1\u0011\b\u0001Q\u0001\ni\na\u0001\\8hO\u0016\u0014\bCA\u001eA\u001b\u0005a$BA\u001f?\u0003\u001dawnZ4j]\u001eT!a\u0010\u0003\u0002\u000f\r|W.\\8og&\u0011\u0011\t\u0010\u0002\u0004\u0019><\u0007BB\"\u0001A\u0003%A)A\u0002ve2\u0004\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\u00079,GOC\u0001J\u0003\u0011Q\u0017M^1\n\u0005-3%aA+S\u0019\"1Q\n\u0001Q\u0005\n9\u000bQB\\;n\u00032Lg/Z\"pe\u0016\u001cX#\u0001\u0011\t\rA\u0003\u0001\u0015\"\u0003R\u0003A9\u0018-\u001b;G_J\u001cuN\u001c3ji&|g\u000e\u0006\u0003S7\u000e$\u0007cA*W16\tAK\u0003\u0002V\u0019\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005]#&A\u0002$viV\u0014X\r\u0005\u0002\f3&\u0011!\f\u0004\u0002\u0005+:LG\u000f\u0003\u0004]\u001f\u0012\u0005\r!X\u0001\nG>tG-\u001b;j_:\u00042a\u00030a\u0013\tyFB\u0001\u0005=Eft\u0017-\\3?!\tY\u0011-\u0003\u0002c\u0019\t9!i\\8mK\u0006t\u0007\"\u0002\u000eP\u0001\u0004Y\u0002bB3P!\u0003\u0005\raG\u0001\u000eG\",7m[%oi\u0016\u0014h/\u00197\t\r\u001d\u0004\u0001\u0015\"\u0003i\u0003-\u0019\u0018MZ3Fq\u0016\u001cW\u000f^3\u0016\u0005%dGC\u00016v!\tYG\u000e\u0004\u0001\u0005\u000b54'\u0019\u00018\u0003\u0003Q\u000b\"a\u001c:\u0011\u0005-\u0001\u0018BA9\r\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aC:\n\u0005Qd!aA!os\"1aO\u001aCA\u0002]\fAAY8esB\u00191B\u00186\t\u000be\u0004A\u0011\u0001>\u0002\u000f\u0015DXmY;uKV\u001110 \u000b\u0003yz\u0004\"a[?\u0005\u000b5D(\u0019\u00018\t\rYDH\u00111\u0001\u0000!\rYa\f \u0005\n\u0003\u0007\u0001\u0011\u0013!C\u0005\u0003\u000b\t!d^1ji\u001a{'oQ8oI&$\u0018n\u001c8%I\u00164\u0017-\u001e7uIM*\"!a\u0002+\u0007m\tIa\u000b\u0002\u0002\fA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011!C;oG\",7m[3e\u0015\r\t)\u0002D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\r\u0003\u001f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class SparkParallelismTracker {
    private final SparkContext sc;
    private final long timeout;
    public final int org$apache$spark$SparkParallelismTracker$$requestedCores;
    private final ObjectMapper mapper;
    private final Log logger;
    private final URL url;

    public SparkContext sc() {
        return this.sc;
    }

    public int org$apache$spark$SparkParallelismTracker$$numAliveCores() {
        int n;
        try {
            n = this.url == null ? Integer.MAX_VALUE : BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.mapper.readTree(this.url).findValues("totalCores")).asScala()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(JsonNode x$1) {
                    return x$1.asInt();
                }
            }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }
        catch (Throwable throwable) {
            this.logger.warn((Object)new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to read total number of alive cores from REST API."})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Health Check will be ignored."})).s((Seq)Nil$.MODULE$)).toString());
            throwable.printStackTrace();
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    private Future<BoxedUnit> waitForCondition(Function0<Object> condition, long timeout, long checkInterval) {
        Future monitor = Future$.MODULE$.apply((Function0)new Serializable(this, condition, checkInterval){
            public static final long serialVersionUID = 0L;
            private final Function0 condition$1;
            private final long checkInterval$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (!this.condition$1.apply$mcZ$sp()) {
                    Thread.sleep(this.checkInterval$1);
                }
                return;
            }
            {
                this.condition$1 = condition$1;
                this.checkInterval$1 = checkInterval$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        return (Future)Await$.MODULE$.ready((Awaitable)monitor, (Duration)new package.DurationLong(package$.MODULE$.DurationLong(timeout)).millis());
    }

    private long waitForCondition$default$3() {
        return 100L;
    }

    /*
     * WARNING - void declaration
     */
    private <T> T safeExecute(Function0<T> body) {
        Object object;
        TaskFailedListener listener = new TaskFailedListener();
        this.sc().addSparkListener((SparkListenerInterface)listener);
        try {
            object = body.apply();
        }
        catch (Throwable throwable) {
            void var2_2;
            this.sc().removeSparkListener((SparkListenerInterface)var2_2);
            throw throwable;
        }
        this.sc().removeSparkListener((SparkListenerInterface)listener);
        return (T)object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(Function0<T> body) {
        Object object;
        if (this.timeout <= 0L) {
            object = body.apply();
            return (T)object;
        }
        try {
            this.waitForCondition((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SparkParallelismTracker $outer;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.org$apache$spark$SparkParallelismTracker$$numAliveCores() >= this.$outer.org$apache$spark$SparkParallelismTracker$$requestedCores;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.timeout, this.waitForCondition$default$3());
        }
        catch (TimeoutException timeoutException) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to get ", " workers for"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.org$apache$spark$SparkParallelismTracker$$requestedCores)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" XGBoost training"})).s((Seq)Nil$.MODULE$)).toString());
        }
        object = this.safeExecute(body);
        return (T)object;
    }

    public SparkParallelismTracker(SparkContext sc, long timeout, int numWorkers) {
        URL uRL;
        this.sc = sc;
        this.timeout = timeout;
        this.org$apache$spark$SparkParallelismTracker$$requestedCores = numWorkers * sc.conf().getInt("spark.task.cpus", 1);
        this.mapper = new ObjectMapper();
        this.logger = LogFactory.getLog((String)"XGBoostSpark");
        Option option = sc.uiWebUrl();
        if (option instanceof Some) {
            Some some = (Some)option;
            String baseUrl = (String)some.x();
            uRL = new URL(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/api/v1/applications/", "/executors"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{baseUrl, sc.applicationId()})));
        } else {
            uRL = null;
        }
        this.url = uRL;
    }
}

