/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.TestCase;
import ml.dmlc.xgboost4j.java.Booster;
import ml.dmlc.xgboost4j.java.DMatrix;
import ml.dmlc.xgboost4j.java.IEvaluation;
import ml.dmlc.xgboost4j.java.XGBoost;
import ml.dmlc.xgboost4j.java.XGBoostError;
import org.junit.Test;

public class BoosterImplTest {
    private Booster trainBooster(DMatrix trainMat, DMatrix testMat) throws XGBoostError {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("eta", 1.0);
                this.put("max_depth", 2);
                this.put("silent", 1);
                this.put("objective", "binary:logistic");
            }
        };
        HashMap<String, DMatrix> watches = new HashMap<String, DMatrix>();
        watches.put("train", trainMat);
        watches.put("test", testMat);
        int round = 5;
        return XGBoost.train((DMatrix)trainMat, (Map)paramMap, (int)round, watches, null, null);
    }

    @Test
    public void testBoosterBasic() throws XGBoostError, IOException {
        EvalError eval2 = new EvalError();
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        Booster booster = this.trainBooster(trainMat, testMat);
        float[][] predicts = booster.predict(testMat, true, 0);
        TestCase.assertTrue((eval2.eval(predicts, testMat) < 0.1f ? 1 : 0) != 0);
    }

    @Test
    public void saveLoadModelWithPath() throws XGBoostError, IOException {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        EvalError eval2 = new EvalError();
        Booster booster = this.trainBooster(trainMat, testMat);
        File temp = File.createTempFile("temp", "model");
        temp.deleteOnExit();
        booster.saveModel(temp.getAbsolutePath());
        Booster bst2 = XGBoost.loadModel((String)temp.getAbsolutePath());
        assert (Arrays.equals(bst2.toByteArray(), booster.toByteArray()));
        float[][] predicts2 = bst2.predict(testMat, true, 0);
        TestCase.assertTrue((eval2.eval(predicts2, testMat) < 0.1f ? 1 : 0) != 0);
    }

    @Test
    public void saveLoadModelWithStream() throws XGBoostError, IOException {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        Booster booster = this.trainBooster(trainMat, testMat);
        Path tempDir = Files.createTempDirectory("boosterTest-", new FileAttribute[0]);
        File tempFile = Files.createTempFile("", "", new FileAttribute[0]).toFile();
        booster.saveModel((OutputStream)new FileOutputStream(tempFile));
        EvalError eval2 = new EvalError();
        Booster loadedBooster = XGBoost.loadModel((InputStream)new FileInputStream(tempFile));
        float originalPredictError = eval2.eval(booster.predict(testMat, true), testMat);
        TestCase.assertTrue((String)("originalPredictErr:" + originalPredictError), (originalPredictError < 0.1f ? 1 : 0) != 0);
        float loadedPredictError = eval2.eval(loadedBooster.predict(testMat, true), testMat);
        TestCase.assertTrue((String)("loadedPredictErr:" + loadedPredictError), (loadedPredictError < 0.1f ? 1 : 0) != 0);
    }

    @Test
    public void testDescendMetricsWithBoundaryCondition() {
        int totalIterations = 11;
        int earlyStoppingRound = 10;
        float[][] metrics = new float[1][totalIterations];
        for (int i = 0; i < totalIterations; ++i) {
            metrics[0][i] = i;
        }
        int bestIteration = 0;
        for (int itr = 0; itr < totalIterations; ++itr) {
            boolean es = XGBoost.shouldEarlyStop((int)earlyStoppingRound, (int)itr, (int)bestIteration);
            if (itr == totalIterations - 1) {
                TestCase.assertTrue((boolean)es);
                continue;
            }
            TestCase.assertFalse((boolean)es);
        }
    }

    @Test
    public void testEarlyStoppingForMultipleMetrics() {
        boolean es;
        int bestIteration;
        int i;
        int earlyStoppingRound = 3;
        int totalIterations = 5;
        int numOfMetrics = 3;
        float[][] metrics = new float[numOfMetrics][totalIterations];
        for (int i2 = 0; i2 < numOfMetrics; ++i2) {
            for (int j = 0; j < totalIterations; ++j) {
                metrics[0][j] = j;
            }
        }
        for (i = 0; i < totalIterations; ++i) {
            bestIteration = i;
            es = XGBoost.shouldEarlyStop((int)earlyStoppingRound, (int)i, (int)bestIteration);
            TestCase.assertFalse((boolean)es);
        }
        for (i = 0; i < totalIterations; ++i) {
            metrics[0][i] = totalIterations - i;
        }
        for (i = 0; i < totalIterations; ++i) {
            bestIteration = i;
            es = XGBoost.shouldEarlyStop((int)earlyStoppingRound, (int)i, (int)bestIteration);
            TestCase.assertFalse((boolean)es);
        }
        for (i = 0; i < totalIterations; ++i) {
            metrics[2][i] = totalIterations - i;
        }
        bestIteration = 0;
        for (i = 0; i < totalIterations; ++i) {
            es = XGBoost.shouldEarlyStop((int)earlyStoppingRound, (int)i, (int)bestIteration);
            if (i >= earlyStoppingRound) {
                TestCase.assertTrue((boolean)es);
                continue;
            }
            TestCase.assertFalse((boolean)es);
        }
    }

    @Test
    public void testDescendMetrics() {
        int i;
        int totalIterations = 10;
        int earlyStoppingRounds = 5;
        float[][] metrics = new float[1][totalIterations];
        for (int i2 = 0; i2 < totalIterations; ++i2) {
            metrics[0][i2] = i2;
        }
        int bestIteration = 0;
        boolean es = XGBoost.shouldEarlyStop((int)earlyStoppingRounds, (int)(totalIterations - 1), (int)bestIteration);
        TestCase.assertTrue((boolean)es);
        for (i = 0; i < totalIterations; ++i) {
            metrics[0][i] = totalIterations - i;
        }
        bestIteration = totalIterations - 1;
        es = XGBoost.shouldEarlyStop((int)earlyStoppingRounds, (int)(totalIterations - 1), (int)bestIteration);
        TestCase.assertFalse((boolean)es);
        for (i = 0; i < totalIterations; ++i) {
            metrics[0][i] = totalIterations - i;
        }
        metrics[0][4] = 1.0f;
        metrics[0][9] = 5.0f;
        bestIteration = 4;
        es = XGBoost.shouldEarlyStop((int)earlyStoppingRounds, (int)(totalIterations - 1), (int)bestIteration);
        TestCase.assertTrue((boolean)es);
    }

    @Test
    public void testAscendMetricsWithBoundaryCondition() {
        int totalIterations = 11;
        int earlyStoppingRounds = 10;
        float[][] metrics = new float[1][totalIterations];
        for (int i = 0; i < totalIterations; ++i) {
            metrics[0][i] = totalIterations - i;
        }
        int bestIteration = 0;
        for (int itr = 0; itr < totalIterations; ++itr) {
            boolean es = XGBoost.shouldEarlyStop((int)earlyStoppingRounds, (int)itr, (int)bestIteration);
            if (itr == totalIterations - 1) {
                TestCase.assertTrue((boolean)es);
                continue;
            }
            TestCase.assertFalse((boolean)es);
        }
    }

    @Test
    public void testAscendMetrics() {
        int i;
        int totalIterations = 10;
        int earlyStoppingRounds = 5;
        float[][] metrics = new float[1][totalIterations];
        for (int i2 = 0; i2 < totalIterations; ++i2) {
            metrics[0][i2] = totalIterations - i2;
        }
        int bestIteration = 0;
        boolean es = XGBoost.shouldEarlyStop((int)earlyStoppingRounds, (int)(totalIterations - 1), (int)bestIteration);
        TestCase.assertTrue((boolean)es);
        for (i = 0; i < totalIterations; ++i) {
            metrics[0][i] = i;
        }
        bestIteration = totalIterations - 1;
        es = XGBoost.shouldEarlyStop((int)earlyStoppingRounds, (int)(totalIterations - 1), (int)bestIteration);
        TestCase.assertFalse((boolean)es);
        for (i = 0; i < totalIterations; ++i) {
            metrics[0][i] = i;
        }
        metrics[0][4] = 9.0f;
        metrics[0][9] = 4.0f;
        bestIteration = 4;
        es = XGBoost.shouldEarlyStop((int)earlyStoppingRounds, (int)(totalIterations - 1), (int)bestIteration);
        TestCase.assertTrue((boolean)es);
    }

    @Test
    public void testBoosterEarlyStop() throws XGBoostError, IOException {
        int r;
        int w;
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("max_depth", 3);
                this.put("silent", 1);
                this.put("objective", "binary:logistic");
                this.put("maximize_evaluation_metrics", "false");
            }
        };
        LinkedHashMap<String, DMatrix> watches = new LinkedHashMap<String, DMatrix>();
        watches.put("training", trainMat);
        watches.put("test", testMat);
        int round = 10;
        int earlyStoppingRound = 2;
        float[][] metrics = new float[watches.size()][10];
        XGBoost.train((DMatrix)trainMat, (Map)paramMap, (int)10, watches, (float[][])metrics, null, (IEvaluation)new IncreasingEval(), (int)earlyStoppingRound);
        for (w = 0; w < watches.size(); ++w) {
            for (r = 0; r <= earlyStoppingRound; ++r) {
                TestCase.assertFalse((0.0f == metrics[w][r] ? 1 : 0) != 0);
            }
        }
        for (w = 0; w < watches.size(); ++w) {
            for (r = earlyStoppingRound + 1; r < 10; ++r) {
                TestCase.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(metrics[w][r]));
            }
        }
    }

    private void testWithQuantileHisto(DMatrix trainingSet, Map<String, DMatrix> watches, int round, Map<String, Object> paramMap, float threshold) throws XGBoostError {
        int j;
        int i;
        float[][] metrics = new float[watches.size()][round];
        Booster booster = XGBoost.train((DMatrix)trainingSet, paramMap, (int)round, watches, (float[][])metrics, null, null, (int)0);
        for (i = 0; i < metrics.length; ++i) {
            for (j = 1; j < metrics[i].length; ++j) {
                TestCase.assertTrue((metrics[i][j] >= metrics[i][j - 1] || (double)Math.abs(metrics[i][j] - metrics[i][j - 1]) < 0.1 ? 1 : 0) != 0);
            }
        }
        for (i = 0; i < metrics.length; ++i) {
            for (j = 0; j < metrics[i].length; ++j) {
                TestCase.assertTrue((metrics[i][j] >= threshold ? 1 : 0) != 0);
            }
        }
        booster.dispose();
    }

    @Test
    public void testQuantileHistoDepthWise() throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("max_depth", 3);
                this.put("silent", 1);
                this.put("objective", "binary:logistic");
                this.put("tree_method", "hist");
                this.put("grow_policy", "depthwise");
                this.put("eval_metric", "auc");
            }
        };
        HashMap<String, DMatrix> watches = new HashMap<String, DMatrix>();
        watches.put("training", trainMat);
        watches.put("test", testMat);
        this.testWithQuantileHisto(trainMat, watches, 10, (Map<String, Object>)paramMap, 0.95f);
    }

    @Test
    public void testQuantileHistoLossGuide() throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("max_depth", 0);
                this.put("silent", 1);
                this.put("objective", "binary:logistic");
                this.put("tree_method", "hist");
                this.put("grow_policy", "lossguide");
                this.put("max_leaves", 8);
                this.put("eval_metric", "auc");
            }
        };
        HashMap<String, DMatrix> watches = new HashMap<String, DMatrix>();
        watches.put("training", trainMat);
        watches.put("test", testMat);
        this.testWithQuantileHisto(trainMat, watches, 10, (Map<String, Object>)paramMap, 0.95f);
    }

    @Test
    public void testQuantileHistoLossGuideMaxBin() throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("max_depth", 0);
                this.put("silent", 1);
                this.put("objective", "binary:logistic");
                this.put("tree_method", "hist");
                this.put("grow_policy", "lossguide");
                this.put("max_leaves", 8);
                this.put("max_bin", 16);
                this.put("eval_metric", "auc");
            }
        };
        HashMap<String, DMatrix> watches = new HashMap<String, DMatrix>();
        watches.put("training", trainMat);
        this.testWithQuantileHisto(trainMat, watches, 10, (Map<String, Object>)paramMap, 0.95f);
    }

    @Test
    public void testDumpModelJson() throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        Booster booster = this.trainBooster(trainMat, testMat);
        String[] dump = booster.getModelDump("", false, "json");
        TestCase.assertEquals((String)"  { \"nodeid\":", (String)dump[0].substring(0, 13));
        String[] featureNames = new String[126];
        for (int i = 0; i < 126; ++i) {
            featureNames[i] = "test_feature_name_" + i;
        }
        dump = booster.getModelDump(featureNames, false, "json");
        TestCase.assertTrue((boolean)dump[0].contains("test_feature_name_"));
    }

    @Test
    public void testGetFeatureScore() throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        Booster booster = this.trainBooster(trainMat, testMat);
        String[] featureNames = new String[126];
        for (int i = 0; i < 126; ++i) {
            featureNames[i] = "test_feature_name_" + i;
        }
        Map scoreMap = booster.getFeatureScore(featureNames);
        for (String fName : scoreMap.keySet()) {
            TestCase.assertTrue((boolean)fName.startsWith("test_feature_name_"));
        }
    }

    @Test
    public void testGetFeatureImportanceGain() throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        Booster booster = this.trainBooster(trainMat, testMat);
        String[] featureNames = new String[126];
        for (int i = 0; i < 126; ++i) {
            featureNames[i] = "test_feature_name_" + i;
        }
        Map scoreMap = booster.getScore(featureNames, "gain");
        for (String fName : scoreMap.keySet()) {
            TestCase.assertTrue((boolean)fName.startsWith("test_feature_name_"));
        }
    }

    @Test
    public void testGetFeatureImportanceTotalGain() throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        Booster booster = this.trainBooster(trainMat, testMat);
        String[] featureNames = new String[126];
        for (int i = 0; i < 126; ++i) {
            featureNames[i] = "test_feature_name_" + i;
        }
        Map scoreMap = booster.getScore(featureNames, "total_gain");
        for (String fName : scoreMap.keySet()) {
            TestCase.assertTrue((boolean)fName.startsWith("test_feature_name_"));
        }
    }

    @Test
    public void testGetFeatureImportanceCover() throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        Booster booster = this.trainBooster(trainMat, testMat);
        String[] featureNames = new String[126];
        for (int i = 0; i < 126; ++i) {
            featureNames[i] = "test_feature_name_" + i;
        }
        Map scoreMap = booster.getScore(featureNames, "cover");
        for (String fName : scoreMap.keySet()) {
            TestCase.assertTrue((boolean)fName.startsWith("test_feature_name_"));
        }
    }

    @Test
    public void testGetFeatureImportanceTotalCover() throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        Booster booster = this.trainBooster(trainMat, testMat);
        String[] featureNames = new String[126];
        for (int i = 0; i < 126; ++i) {
            featureNames[i] = "test_feature_name_" + i;
        }
        Map scoreMap = booster.getScore(featureNames, "total_cover");
        for (String fName : scoreMap.keySet()) {
            TestCase.assertTrue((boolean)fName.startsWith("test_feature_name_"));
        }
    }

    @Test
    public void testQuantileHistoDepthwiseMaxDepth() throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("max_depth", 3);
                this.put("silent", 1);
                this.put("objective", "binary:logistic");
                this.put("tree_method", "hist");
                this.put("grow_policy", "depthwise");
                this.put("eval_metric", "auc");
            }
        };
        HashMap<String, DMatrix> watches = new HashMap<String, DMatrix>();
        watches.put("training", trainMat);
        this.testWithQuantileHisto(trainMat, watches, 10, (Map<String, Object>)paramMap, 0.95f);
    }

    @Test
    public void testQuantileHistoDepthwiseMaxDepthMaxBin() throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("max_depth", 3);
                this.put("silent", 1);
                this.put("objective", "binary:logistic");
                this.put("tree_method", "hist");
                this.put("max_bin", 2);
                this.put("grow_policy", "depthwise");
                this.put("eval_metric", "auc");
            }
        };
        HashMap<String, DMatrix> watches = new HashMap<String, DMatrix>();
        watches.put("training", trainMat);
        this.testWithQuantileHisto(trainMat, watches, 10, (Map<String, Object>)paramMap, 0.95f);
    }

    @Test
    public void testCV() throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        HashMap<String, Object> param = new HashMap<String, Object>(){
            {
                this.put("eta", 1.0);
                this.put("max_depth", 3);
                this.put("silent", 1);
                this.put("nthread", 6);
                this.put("objective", "binary:logistic");
                this.put("gamma", 1.0);
                this.put("eval_metric", "error");
            }
        };
        int round = 2;
        int nfold = 5;
        String[] evalHist = XGBoost.crossValidation((DMatrix)trainMat, (Map)param, (int)round, (int)nfold, null, null, null);
    }

    @Test
    public void testTrainFromExistingModel() throws XGBoostError, IOException {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        EvalError eval2 = new EvalError();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(){
            {
                this.put("eta", 1.0);
                this.put("max_depth", 2);
                this.put("silent", 1);
                this.put("objective", "binary:logistic");
            }
        };
        HashMap<String, DMatrix> watches = new HashMap<String, DMatrix>();
        watches.put("train", trainMat);
        watches.put("test", testMat);
        int round = 4;
        Booster booster1 = XGBoost.train((DMatrix)trainMat, (Map)paramMap, (int)round, watches, (float[][])null, null, null, (int)0);
        float booster1error = eval2.eval(booster1.predict(testMat, true, 0), testMat);
        round = 2;
        Booster tempBooster = XGBoost.train((DMatrix)trainMat, (Map)paramMap, (int)round, watches, (float[][])null, null, null, (int)0);
        float tempBoosterError = eval2.eval(tempBooster.predict(testMat, true, 0), testMat);
        int prevVersion = tempBooster.getVersion();
        ByteArrayInputStream in = new ByteArrayInputStream(tempBooster.toByteArray());
        tempBooster = XGBoost.loadModel((InputStream)in);
        in.close();
        tempBooster.setVersion(prevVersion);
        round = 4;
        Booster booster2 = XGBoost.train((DMatrix)trainMat, (Map)paramMap, (int)round, watches, (float[][])null, null, null, (int)0, (Booster)tempBooster);
        float booster2error = eval2.eval(booster2.predict(testMat, true, 0), testMat);
        TestCase.assertTrue((booster1error == booster2error ? 1 : 0) != 0);
        TestCase.assertTrue((tempBoosterError > booster2error ? 1 : 0) != 0);
    }

    @Test
    public void testSetAndGetAttrs() throws XGBoostError {
        DMatrix trainMat = new DMatrix("../../demo/data/agaricus.txt.train");
        DMatrix testMat = new DMatrix("../../demo/data/agaricus.txt.test");
        Booster booster = this.trainBooster(trainMat, testMat);
        booster.setAttr("testKey1", "testValue1");
        TestCase.assertEquals((String)booster.getAttr("testKey1"), (String)"testValue1");
        booster.setAttr("testKey1", "testValue2");
        TestCase.assertEquals((String)booster.getAttr("testKey1"), (String)"testValue2");
        booster.setAttrs((Map)new HashMap<String, String>(){
            {
                this.put("aa", "AA");
                this.put("bb", "BB");
                this.put("cc", "CC");
            }
        });
        Map attr = booster.getAttrs();
        TestCase.assertEquals((int)attr.size(), (int)4);
        TestCase.assertEquals((String)((String)attr.get("testKey1")), (String)"testValue2");
        TestCase.assertEquals((String)((String)attr.get("aa")), (String)"AA");
        TestCase.assertEquals((String)((String)attr.get("bb")), (String)"BB");
        TestCase.assertEquals((String)((String)attr.get("cc")), (String)"CC");
    }

    private static class IncreasingEval
    implements IEvaluation {
        private int value = 1;

        private IncreasingEval() {
        }

        public String getMetric() {
            return "inc";
        }

        public float eval(float[][] predicts, DMatrix dmat) {
            return this.value++;
        }
    }

    public static class EvalError
    implements IEvaluation {
        public String getMetric() {
            return "custom_error";
        }

        public float eval(float[][] predicts, DMatrix dmat) {
            float[] labels;
            float error = 0.0f;
            try {
                labels = dmat.getLabel();
            }
            catch (XGBoostError ex) {
                throw new RuntimeException(ex);
            }
            int nrow = predicts.length;
            for (int i = 0; i < nrow; ++i) {
                if (labels[i] == 0.0f && predicts[i][0] > 0.0f) {
                    error += 1.0f;
                    continue;
                }
                if (labels[i] != 1.0f || !(predicts[i][0] <= 0.0f)) continue;
                error += 1.0f;
            }
            return error / (float)labels.length;
        }
    }
}

