/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.InitializeException;
import io.github.toolfactory.jvm.function.catalog.AllocateInstanceFunction;
import io.github.toolfactory.jvm.function.catalog.ConsulterSupplier;
import io.github.toolfactory.jvm.function.catalog.ConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.catalog.DefineHookClassFunction;
import io.github.toolfactory.jvm.function.catalog.GetDeclaredMethodFunction;
import io.github.toolfactory.jvm.function.catalog.SetFieldValueFunction;
import io.github.toolfactory.jvm.function.template.ThrowingBiConsumer;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.jvm.util.Streams;
import io.github.toolfactory.jvm.util.Strings;
import io.github.toolfactory.jvm.util.ThrowingBiConsumerAdapter;
import io.github.toolfactory.narcissus.Narcissus;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.BiConsumer;

public interface SetAccessibleFunction
extends ThrowingBiConsumer<AccessibleObject, Boolean, Throwable> {

    public static interface Native
    extends SetAccessibleFunction {

        public static class ForJava9
        extends Abst<ThrowingBiConsumer<AccessibleObject, Boolean, Throwable>>
        implements Native {
            public ForJava9(Map<Object, Object> context) throws Throwable {
                super(context);
                this.checkNativeEngine();
                ObjectProvider functionProvider = ObjectProvider.get(context);
                GetDeclaredMethodFunction getDeclaredMethodFunction = functionProvider.getOrBuildObject(GetDeclaredMethodFunction.class, context);
                final Method accessibleSetterMethod = (Method)getDeclaredMethodFunction.apply(AccessibleObject.class, "setAccessible0", new Class[]{Boolean.TYPE});
                this.setFunction(new ThrowingBiConsumer<AccessibleObject, Boolean, Throwable>(){

                    @Override
                    public void accept(AccessibleObject target, Boolean flag) {
                        Narcissus.invokeMethod(target, accessibleSetterMethod, flag);
                    }
                });
            }

            protected void checkNativeEngine() throws InitializeException {
                if (!Narcissus.libraryLoaded) {
                    throw new InitializeException(Strings.compile("Could not initialize the native engine {}", Narcissus.class.getName()));
                }
            }

            @Override
            public void accept(AccessibleObject accessibleObject, Boolean flag) throws Throwable {
                ((ThrowingBiConsumer)this.function).accept(accessibleObject, flag);
            }
        }

        public static class ForJava7
        extends Abst<ThrowingBiConsumer<AccessibleObject, Boolean, Throwable>>
        implements Native {
            public ForJava7(Map<Object, Object> context) throws Throwable {
                super(context);
                ObjectProvider functionProvider = ObjectProvider.get(context);
                GetDeclaredMethodFunction getDeclaredMethodFunction = functionProvider.getOrBuildObject(GetDeclaredMethodFunction.class, context);
                Method accessibleSetterMethod = (Method)getDeclaredMethodFunction.apply(AccessibleObject.class, "setAccessible0", new Class[]{AccessibleObject.class, Boolean.TYPE});
                final MethodHandle accessibleSetterMethodHandle = ((MethodHandles.Lookup)functionProvider.getOrBuildObject(ConsulterSupplier.class, context).get()).unreflect(accessibleSetterMethod);
                this.setFunction(new ThrowingBiConsumer<AccessibleObject, Boolean, Throwable>(){

                    @Override
                    public void accept(AccessibleObject accessibleObject, Boolean flag) throws Throwable {
                        accessibleSetterMethodHandle.invokeWithArguments(accessibleObject, flag);
                    }
                });
            }

            @Override
            public void accept(AccessibleObject accessibleObject, Boolean flag) throws Throwable {
                ((ThrowingBiConsumer)this.function).accept(accessibleObject, flag);
            }
        }
    }

    public static class ForJava9
    extends Abst<BiConsumer<AccessibleObject, Boolean>> {
        public ForJava9(Map<Object, Object> context) throws Throwable {
            super(context);
            try (InputStream inputStream = this.getClass().getResourceAsStream("AccessibleSetterInvokerForJDK9.bwc");){
                ObjectProvider functionProvider = ObjectProvider.get(context);
                Class methodHandleWrapperClass = (Class)functionProvider.getOrBuildObject(DefineHookClassFunction.class, context).apply(AccessibleObject.class, Streams.toByteArray(inputStream));
                functionProvider.getOrBuildObject(SetFieldValueFunction.class, context).accept(methodHandleWrapperClass, methodHandleWrapperClass.getDeclaredField("methodHandleRetriever"), functionProvider.getOrBuildObject(ConsulterSupplyFunction.class, context).apply(methodHandleWrapperClass));
                this.setFunction((BiConsumer)functionProvider.getOrBuildObject(AllocateInstanceFunction.class, context).apply(methodHandleWrapperClass));
            }
        }

        @Override
        public void accept(AccessibleObject accessibleObject, Boolean flag) {
            ((BiConsumer)this.function).accept(accessibleObject, flag);
        }
    }

    public static class ForJava7
    extends Abst<ThrowingBiConsumer<AccessibleObject, Boolean, Throwable>> {
        public ForJava7(Map<Object, Object> context) throws NoSuchMethodException, SecurityException, IllegalAccessException {
            super(context);
            Method accessibleSetterMethod = AccessibleObject.class.getDeclaredMethod("setAccessible0", AccessibleObject.class, Boolean.TYPE);
            ObjectProvider functionProvider = ObjectProvider.get(context);
            final MethodHandle accessibleSetterMethodHandle = ((MethodHandles.Lookup)functionProvider.getOrBuildObject(ConsulterSupplier.class, context).get()).unreflect(accessibleSetterMethod);
            this.setFunction(new ThrowingBiConsumer<AccessibleObject, Boolean, Throwable>(){

                @Override
                public void accept(AccessibleObject accessibleObject, Boolean flag) throws Throwable {
                    accessibleSetterMethodHandle.invokeWithArguments(accessibleObject, flag);
                }
            });
        }

        @Override
        public void accept(AccessibleObject accessibleObject, Boolean flag) throws Throwable {
            ((ThrowingBiConsumer)this.function).accept(accessibleObject, flag);
        }
    }

    public static abstract class Abst<B>
    extends ThrowingBiConsumerAdapter<B, AccessibleObject, Boolean, Throwable>
    implements SetAccessibleFunction {
        public Abst(Map<Object, Object> context) {
        }
    }
}

