/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bukkit;

import java.util.function.BiConsumer;
import ml.karmaconfigs.api.bukkit.scheduler.BukkitAsyncScheduler;
import ml.karmaconfigs.api.bukkit.scheduler.BukkitSyncScheduler;
import ml.karmaconfigs.api.common.Console;
import ml.karmaconfigs.api.common.karma.APISource;
import ml.karmaconfigs.api.common.karma.KarmaAPI;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.timer.scheduler.Scheduler;
import ml.karmaconfigs.api.common.timer.worker.AsyncScheduler;
import ml.karmaconfigs.api.common.timer.worker.SyncScheduler;
import ml.karmaconfigs.api.common.utils.placeholder.GlobalPlaceholderEngine;
import ml.karmaconfigs.api.common.utils.placeholder.util.Placeholder;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public abstract class KarmaPlugin
extends JavaPlugin
implements KarmaSource {
    private final Console console;
    private Scheduler async;
    private Scheduler sync;

    public KarmaPlugin() {
        KarmaAPI.install();
        this.console = new Console(this, msg -> Bukkit.getServer().getConsoleSender().sendMessage(StringUtils.toColor(msg)));
        this.async = new AsyncScheduler<KarmaPlugin>(this);
        this.sync = new SyncScheduler<KarmaPlugin>(this);
        if (!APISource.hasProvider(this.name())) {
            APISource.addProvider(this);
        }
    }

    public KarmaPlugin(boolean defineDefault) throws SecurityException {
        KarmaAPI.install();
        this.console = new Console(this, msg -> Bukkit.getServer().getConsoleSender().sendMessage(StringUtils.toColor(msg)));
        this.async = new AsyncScheduler<KarmaPlugin>(this);
        this.sync = new SyncScheduler<KarmaPlugin>(this);
        if (!APISource.hasProvider(this.name())) {
            APISource.addProvider(this);
            if (defineDefault) {
                APISource.defineDefault(this);
            }
        }
    }

    public abstract void enable();

    public final void onEnable() {
        this.async = new BukkitAsyncScheduler<KarmaPlugin>(this);
        this.sync = new BukkitSyncScheduler<KarmaPlugin>(this);
        this.enable();
    }

    @Override
    public Scheduler async() {
        return this.async;
    }

    @Override
    public Scheduler sync() {
        return this.sync;
    }

    @Override
    public Console console() {
        return this.console;
    }

    public static Placeholder<String> createTextPlaceholder(final String key, final BiConsumer<Player, String> onRequest) {
        return new Placeholder<String>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public String getValue(@Nullable Object container) {
                if (container instanceof Player) {
                    Player player = (Player)container;
                    String original = "placeholder " + key + " value";
                    onRequest.accept(player, original);
                    return original;
                }
                return StringUtils.toColor("&ccontainer not a player");
            }

            @Override
            public Class<?> getType() {
                return Player.class;
            }
        };
    }

    public static Placeholder<Integer> createIntegerPlaceholder(final String key, final BiConsumer<Player, Integer> onRequest) {
        return new Placeholder<Integer>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Integer getValue(@Nullable Object container) {
                if (container instanceof Player) {
                    Player player = (Player)container;
                    int original = Integer.MAX_VALUE;
                    onRequest.accept(player, original);
                    return original;
                }
                return Integer.MIN_VALUE;
            }

            @Override
            public Class<?> getType() {
                return Player.class;
            }
        };
    }

    public static Placeholder<Double> createDoublePlaceholder(final String key, final BiConsumer<Player, Double> onRequest) {
        return new Placeholder<Double>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Double getValue(@Nullable Object container) {
                if (container instanceof Player) {
                    Player player = (Player)container;
                    double original = Double.MAX_VALUE;
                    onRequest.accept(player, original);
                    return original;
                }
                return Double.MIN_VALUE;
            }

            @Override
            public Class<?> getType() {
                return Player.class;
            }
        };
    }

    public static Placeholder<Float> createFloatPlaceholder(final String key, final BiConsumer<Player, Float> onRequest) {
        return new Placeholder<Float>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public Float getValue(@Nullable Object container) {
                if (container instanceof Player) {
                    Player player = (Player)container;
                    float original = Float.MAX_VALUE;
                    onRequest.accept(player, Float.valueOf(original));
                    return Float.valueOf(original);
                }
                return Float.valueOf(Float.MIN_VALUE);
            }

            @Override
            public Class<?> getType() {
                return Player.class;
            }
        };
    }

    public static <T> Placeholder<T> createAnyPlaceholder(final String key, final BiConsumer<Player, T> onRequest) {
        return new Placeholder<T>(){

            @Override
            public String getKey() {
                return key;
            }

            @Override
            public T getValue(@Nullable Object container) {
                if (container instanceof Player) {
                    Player player = (Player)container;
                    Object original = null;
                    onRequest.accept(player, original);
                    return original;
                }
                return null;
            }

            @Override
            public Class<?> getType() {
                return Player.class;
            }
        };
    }

    public static void registerPlayerPlaceholder(Placeholder<?> ... placeholders) {
        GlobalPlaceholderEngine engine = new GlobalPlaceholderEngine(KarmaAPI.source(false));
        engine.protect();
        engine.registerUnsafe(placeholders);
    }
}

