/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bukkit.reflection;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import ml.karmaconfigs.api.bukkit.server.BukkitServer;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public final class BarMessage {
    private static final Map<UUID, BarMessage> data = new ConcurrentHashMap<UUID, BarMessage>();
    private final Player player;
    private String message;
    private boolean sent = false;
    private boolean send = false;
    private int remaining = 0;

    public BarMessage(Player p, @Nullable String m) {
        this.player = p;
        this.message = m;
    }

    private void send() {
        String msg = StringUtils.toColor(this.message);
        try {
            Constructor<?> constructor = Objects.requireNonNull(BukkitServer.getMinecraftClass("PacketPlayOutChat")).getConstructor(BukkitServer.getMinecraftClass("IChatBaseComponent"), Byte.TYPE);
            Object icbc = Objects.requireNonNull(BukkitServer.getMinecraftClass("IChatBaseComponent")).getDeclaredClasses()[0].getMethod("a", String.class).invoke(null, "{\"text\":\"" + msg + "\"}");
            Object packet = constructor.newInstance(icbc, (byte)2);
            Object entityPlayer = this.player.getClass().getMethod("getHandle", new Class[0]).invoke((Object)this.player, new Object[0]);
            Object playerConnection = entityPlayer.getClass().getField("playerConnection").get(entityPlayer);
            playerConnection.getClass().getMethod("sendPacket", BukkitServer.getMinecraftClass("Packet")).invoke(playerConnection, packet);
            this.sent = true;
        }
        catch (Throwable ex) {
            try {
                this.player.spigot().sendMessage(ChatMessageType.ACTION_BAR, UUID.randomUUID(), TextComponent.fromLegacyText((String)msg));
                this.sent = true;
            }
            catch (Throwable exc) {
                this.player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)msg));
                this.sent = true;
            }
        }
    }

    public void send(boolean persistent) {
        if (this.player != null && this.player.isOnline()) {
            BarMessage stored = data.getOrDefault(this.player.getUniqueId(), null);
            if (stored != null) {
                stored.stop();
            }
            this.send = persistent;
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (!BarMessage.this.send) {
                        this.cancel();
                    }
                    BarMessage.this.send();
                }
            }, 0L, TimeUnit.SECONDS.toMillis(1L));
            data.put(this.player.getUniqueId(), this);
        }
    }

    public void send(int repeats) {
        if (this.player != null && this.player.isOnline()) {
            BarMessage stored = data.getOrDefault(this.player.getUniqueId(), null);
            if (stored != null) {
                stored.stop();
                stored.remaining = 0;
            }
            this.remaining = repeats;
            this.send = true;
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){
                int repeated = 0;

                @Override
                public void run() {
                    if (!BarMessage.this.send) {
                        BarMessage.this.stop();
                    }
                    ++this.repeated;
                    BarMessage.this.send();
                    if (this.repeated >= BarMessage.this.remaining) {
                        this.cancel();
                    }
                }
            }, 0L, TimeUnit.SECONDS.toMillis(2L));
            if (stored != null) {
                data.put(this.player.getUniqueId(), this);
            }
        }
    }

    public void setMessage(String _message) {
        this.message = _message;
    }

    public void stop() {
        this.send = false;
    }

    public boolean isSent() {
        return this.sent;
    }
}

