/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bukkit.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.api.bukkit.server.BukkitServer;
import ml.karmaconfigs.api.bukkit.server.Version;
import ml.karmaconfigs.api.common.boss.BossColor;
import ml.karmaconfigs.api.common.boss.BossNotFoundException;
import ml.karmaconfigs.api.common.boss.BossProvider;
import ml.karmaconfigs.api.common.boss.BossType;
import ml.karmaconfigs.api.common.boss.ProgressiveBar;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.timer.SourceSecondsTimer;
import ml.karmaconfigs.api.common.timer.TimeCondition;
import ml.karmaconfigs.api.common.timer.scheduler.SimpleScheduler;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public final class BossMessage
extends BossProvider<Player> {
    private final KarmaSource plugin;
    private String message;
    private final double live_time;
    private static int bars = 0;
    private static boolean isLegacy = BukkitServer.isUnder(Version.v1_13);
    private static boolean toFloat = false;
    private static Class<?> craft_world;
    private static Class<?> craft_player;
    private static Class<?> packet_class;
    private static Class<?> packet_connection;
    private static Class<?> packet_play_out_destroy;
    private static Constructor<?> wither_constructor;
    private static Constructor<?> entity_living_constructor;
    private static Constructor<?> packet_play_teleport_constructor;
    private static Method craft_world_handle;
    private static Method craft_player_handle;
    private static Method packet_connect_send;
    private static Method wither_set_location_method;
    private static Method wither_set_progress_method;
    private static final List<BossMessage> b_bars;
    private static final Map<Integer, BossMessage> boss_bars;
    private static final Map<Integer, Object> wither_objects;
    private final Set<UUID> shown = Collections.newSetFromMap(new ConcurrentHashMap());
    private BossColor color = BossColor.PURPLE;
    private BossType type = BossType.SOLID;
    private ProgressiveBar progress = ProgressiveBar.NONE;
    private double lived_time = 0.0;
    private boolean cancelled = false;
    private static int total_ids;
    private final int id;
    private SimpleScheduler bar_timer = null;
    private Location newLoc;
    private Object teleport_packet;
    private Object new_c_player;
    private Object new_e_player;
    private Object new_p_connection;
    private Object remove_wither;

    public BossMessage(KarmaSource owner, String _message, double duration) {
        this.plugin = owner;
        this.message = _message;
        this.live_time = duration;
        if (isLegacy) {
            this.doReflectionStuff();
        }
        this.id = ++total_ids;
    }

    @Override
    public BossProvider<Player> color(BossColor newColor) {
        this.color = newColor;
        return this;
    }

    @Override
    public BossProvider<Player> style(BossType newType) {
        this.type = newType;
        try {
            BossBar wither = (BossBar)wither_objects.get(this.id);
            wither.setColor(BarColor.valueOf((String)this.color.name()));
            wither.setVisible(false);
            wither.setVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public BossProvider<Player> progress(ProgressiveBar type) {
        this.progress = type;
        try {
            BossBar wither = (BossBar)wither_objects.get(this.id);
            wither.setStyle(BarStyle.valueOf((String)type.name()));
            wither.setVisible(false);
            wither.setVisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    protected void displayBar(Collection<Player> players) {
        ++bars;
        if (this.cancelled) {
            this.cancelled = false;
        }
        switch (this.progress) {
            case DOWN: {
                this.lived_time = this.live_time - 1.0;
                break;
            }
            case UP: {
                this.lived_time = 0.0;
            }
        }
        if (isLegacy) {
            try {
                for (Player player : players) {
                    if (this.shown.contains(player.getUniqueId())) continue;
                    this.shown.add(player.getUniqueId());
                    Location location = player.getLocation();
                    Object c_world = craft_world.cast(player.getWorld());
                    Object w_server = craft_world_handle.invoke(c_world, new Object[0]);
                    Object wither = wither_constructor.newInstance(w_server);
                    wither.getClass().getMethod("setCustomName", String.class).invoke(wither, this.message);
                    wither.getClass().getMethod("setInvisible", Boolean.TYPE).invoke(wither, true);
                    wither.getClass().getMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE).invoke(wither, location.getX(), location.getY(), location.getZ(), 0, 0);
                    Object packet = entity_living_constructor.newInstance(wither);
                    Object c_player = craft_player.cast(player);
                    Object e_player = craft_player_handle.invoke(c_player, new Object[0]);
                    Object p_connection = e_player.getClass().getField("playerConnection").get(e_player);
                    packet_connect_send.invoke(packet_connection.cast(p_connection), packet);
                    wither_objects.put(this.id, wither);
                    this.bar_timer = new SourceSecondsTimer(this.plugin, this.live_time, false).cancelUnloaded(false);
                    this.bar_timer.conditionalAction(TimeCondition.OVER_OF, 2, second -> {
                        try {
                            this.newLoc = player.getEyeLocation().add(player.getEyeLocation().getDirection().normalize().multiply(20).add(new Vector(0, 5, 0)));
                            wither_set_location_method.invoke((Object)player, this.newLoc.getX(), this.newLoc.getY(), this.newLoc.getZ(), Float.valueOf(this.newLoc.getYaw()), Float.valueOf(this.newLoc.getPitch()));
                            this.teleport_packet = packet_play_teleport_constructor.newInstance(player);
                            this.new_c_player = craft_player.cast(player);
                            this.new_e_player = craft_player_handle.invoke(this.new_c_player, new Object[0]);
                            this.new_p_connection = this.new_e_player.getClass().getField("playerConnection").get(this.new_e_player);
                            packet_connection = BukkitServer.getMinecraftClass("PlayerConnection");
                            packet_class = BukkitServer.getMinecraftClass("Packet");
                            packet_connect_send.invoke(packet_connection.cast(this.new_p_connection), this.teleport_packet);
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                            this.bar_timer.cancel();
                        }
                    }).endAction(() -> {
                        try {
                            this.remove_wither = packet_play_out_destroy.getConstructor(BukkitServer.getMinecraftClass("EntityLiving")).newInstance(player.getUniqueId());
                            packet_connection = BukkitServer.getMinecraftClass("PlayerConnection");
                            packet_class = BukkitServer.getMinecraftClass("Packet");
                            craft_player = BukkitServer.getMinecraftClass("entity.CraftPlayer");
                            if (craft_player != null) {
                                this.new_c_player = craft_player.cast(player);
                                this.new_e_player = craft_player_handle.invoke(this.new_c_player, new Object[0]);
                                this.new_p_connection = this.new_e_player.getClass().getField("playerConnection").get(this.new_e_player);
                                packet_connect_send.invoke(packet_connection.cast(this.new_p_connection), this.remove_wither);
                                boss_bars.remove(this.id);
                                wither_objects.remove(this.id);
                                this.shown.remove(player.getUniqueId());
                                --bars;
                            }
                        }
                        catch (Throwable ex2) {
                            ex2.printStackTrace();
                            this.bar_timer.cancel();
                        }
                    }).cancelAction(time -> {
                        try {
                            this.remove_wither = packet_play_out_destroy.getConstructor(BukkitServer.getMinecraftClass("EntityLiving")).newInstance(player.getUniqueId());
                            packet_connection = BukkitServer.getMinecraftClass("PlayerConnection");
                            packet_class = BukkitServer.getMinecraftClass("Packet");
                            craft_player = BukkitServer.getMinecraftClass("entity.CraftPlayer");
                            if (craft_player != null) {
                                this.new_c_player = craft_player.cast(player);
                                this.new_e_player = craft_player_handle.invoke(this.new_c_player, new Object[0]);
                                this.new_p_connection = this.new_e_player.getClass().getField("playerConnection").get(this.new_e_player);
                                packet_connect_send.invoke(packet_connection.cast(this.new_p_connection), this.remove_wither);
                                boss_bars.remove(this.id);
                                wither_objects.remove(this.id);
                                this.shown.remove(player.getUniqueId());
                                --bars;
                            }
                        }
                        catch (Throwable ex3) {
                            ex3.printStackTrace();
                            this.bar_timer.cancel();
                        }
                    }).start();
                    SimpleScheduler hp_timer = new SourceSecondsTimer(this.plugin, this.live_time - 1.0, false).cancelUnloaded(false);
                    hp_timer.secondChangeAction(second -> {
                        if (!this.cancelled) {
                            try {
                                switch (this.progress) {
                                    case UP: {
                                        double percentage = this.lived_time / this.live_time;
                                        wither_set_progress_method.invoke(wither, toFloat ? (double)((float)percentage) : percentage);
                                        this.lived_time -= 1.0;
                                        break;
                                    }
                                    case DOWN: {
                                        double percentage = (double)second.intValue() / this.live_time;
                                        wither_set_progress_method.invoke(wither, toFloat ? (double)((float)percentage) : percentage);
                                        this.lived_time -= 1.0;
                                    }
                                }
                            }
                            catch (Throwable ex5) {
                                this.cancel();
                            }
                        } else {
                            this.bar_timer.cancel();
                            hp_timer.cancel();
                        }
                    }).start();
                }
            }
            catch (Throwable ex4) {
                ex4.printStackTrace();
            }
        } else {
            BossBar wither = Bukkit.getServer().createBossBar(StringUtils.toColor(this.message), BarColor.valueOf((String)this.color.name()), BarStyle.valueOf((String)this.type.name()), new BarFlag[0]);
            for (Player player2 : players) {
                wither.addPlayer(player2);
            }
            wither.setVisible(true);
            wither_objects.put(this.id, wither);
            this.bar_timer = new SourceSecondsTimer(this.plugin, this.live_time, false).cancelUnloaded(false);
            this.bar_timer.endAction(() -> {
                wither.setVisible(false);
                wither.removeAll();
                boss_bars.remove(this.id);
                wither_objects.remove(this.id);
                for (Player player : players) {
                    this.shown.remove(player.getUniqueId());
                }
                --bars;
            }).cancelAction(end -> {
                wither.setVisible(false);
                wither.removeAll();
                boss_bars.remove(this.id);
                wither_objects.remove(this.id);
                for (Player player : players) {
                    this.shown.remove(player.getUniqueId());
                }
                --bars;
            }).start();
            SimpleScheduler hp_timer = new SourceSecondsTimer(this.plugin, this.live_time - 1.0, false).cancelUnloaded(false);
            hp_timer.secondChangeAction(second -> {
                if (!this.cancelled) {
                    try {
                        wither.setColor(BarColor.valueOf((String)this.color.name()));
                        wither.setStyle(BarStyle.valueOf((String)this.type.name()));
                        switch (this.progress) {
                            case UP: {
                                double percentage = this.lived_time / this.live_time;
                                wither.setProgress(percentage);
                                this.lived_time += 1.0;
                                break;
                            }
                            case DOWN: {
                                double percentage = (double)second.intValue() / this.live_time;
                                wither.setProgress(percentage);
                                this.lived_time -= 1.0;
                            }
                        }
                    }
                    catch (Throwable ex6) {
                        this.cancel();
                    }
                } else {
                    this.bar_timer.cancel();
                    hp_timer.cancel();
                }
            }).start();
        }
    }

    @Override
    public void scheduleBar(Collection<Player> players) {
        b_bars.add(this);
        boss_bars.put(this.id, this);
        SimpleScheduler timer = new SourceSecondsTimer(this.plugin, 1, false).cancelUnloaded(false).multiThreading(true);
        timer.periodChangeAction(milli -> {
            if (!b_bars.isEmpty() && this.getBarsAmount() < 4) {
                BossMessage boss = b_bars.get(0);
                boss.displayBar(players);
                b_bars.remove(boss);
            }
        }).start();
    }

    @Override
    public void scheduleBar(Player player) {
        b_bars.add(this);
        boss_bars.put(this.id, this);
        SimpleScheduler timer = new SourceSecondsTimer(this.plugin, 1, false).cancelUnloaded(false).multiThreading(true);
        timer.periodChangeAction(milli -> {
            if (!b_bars.isEmpty() && this.getBarsAmount() < 4) {
                BossMessage boss = b_bars.get(0);
                boss.displayBar((Collection<Player>)Collections.singleton(player));
                b_bars.remove(boss);
            }
        }).start();
    }

    @Override
    public int getBarsAmount() {
        return bars;
    }

    @Override
    public int getBarId() {
        return this.id;
    }

    @Override
    public boolean update(String _message, boolean restart) {
        try {
            this.message = _message;
            if (isLegacy) {
                Object wither = wither_objects.get(this.id);
                wither.getClass().getMethod("setCustomName", String.class).invoke(wither, StringUtils.toColor(this.message));
            } else {
                BossBar bar = (BossBar)wither_objects.get(this.id);
                bar.setTitle(StringUtils.toColor(this.message));
                List players = bar.getPlayers();
                players.forEach(arg_0 -> ((BossBar)bar).addPlayer(arg_0));
            }
            if (this.bar_timer != null && restart) {
                this.bar_timer.restart();
            }
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public BossProvider<Player> displayTime(double displayTime) {
        this.cancel();
        return new BossMessage(this.plugin, this.message, displayTime).color(this.color).style(this.type).progress(this.progress);
    }

    @Override
    public boolean isValid() {
        return wither_objects.containsKey(this.id);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public String getTitle() {
        return this.message;
    }

    @Override
    public BossColor getColor() {
        return this.color;
    }

    @Override
    public BossType getStyle() {
        return this.type;
    }

    private void doReflectionStuff() {
        block10: {
            try {
                Class<?> packet_entity_living_out;
                craft_world = BukkitServer.getBukkitClass("CraftWorld");
                Class<?> entity_wither = BukkitServer.getMinecraftClass("EntityWither");
                if (entity_wither == null || (packet_entity_living_out = BukkitServer.getMinecraftClass("PacketPlayOutSpawnEntityLiving")) == null) break block10;
                craft_player = BukkitServer.getBukkitClass("entity.CraftPlayer");
                packet_class = BukkitServer.getMinecraftClass("Packet");
                packet_connection = BukkitServer.getMinecraftClass("PlayerConnection");
                packet_play_out_destroy = BukkitServer.getMinecraftClass("PacketPlayOutEntityDestroy");
                Class<?> packet_play_teleport = BukkitServer.getMinecraftClass("PacketPlayOutEntityTeleport");
                if (packet_play_teleport == null) break block10;
                wither_constructor = entity_wither.getConstructor(BukkitServer.getMinecraftClass("World"));
                entity_living_constructor = packet_entity_living_out.getConstructor(BukkitServer.getMinecraftClass("EntityLiving"));
                packet_play_teleport_constructor = packet_play_teleport.getConstructor(BukkitServer.getMinecraftClass("Entity"));
                craft_world_handle = craft_world.getMethod("getHandle", new Class[0]);
                craft_player_handle = craft_player.getMethod("getHandle", new Class[0]);
                packet_connect_send = packet_connection.getMethod("sendPacket", packet_class);
                wither_set_location_method = entity_wither.getMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
                wither_set_location_method = entity_wither.getMethod("setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
                try {
                    wither_set_progress_method = entity_wither.getMethod("setProgress", Double.TYPE);
                }
                catch (Throwable ex) {
                    try {
                        wither_set_progress_method = entity_wither.getMethod("setProgress", Float.TYPE);
                        toFloat = true;
                    }
                    catch (Throwable exc) {
                        try {
                            wither_set_progress_method = entity_wither.getMethod("setHealth", Double.TYPE);
                        }
                        catch (Throwable exce) {
                            try {
                                wither_set_progress_method = entity_wither.getMethod("setHealth", Float.TYPE);
                                toFloat = true;
                            }
                            catch (Throwable excep) {
                                isLegacy = false;
                            }
                        }
                    }
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    static {
        b_bars = new ArrayList<BossMessage>();
        boss_bars = new LinkedHashMap<Integer, BossMessage>();
        wither_objects = new LinkedHashMap<Integer, Object>();
        total_ids = 0;
    }

    public static interface getters {
        public static BossProvider<Player> getByID(int id) throws BossNotFoundException {
            try {
                BossProvider boss;
                if (boss_bars.containsKey(id) && (boss = (BossProvider)boss_bars.getOrDefault(id, null)) != null) {
                    return boss;
                }
                throw new BossNotFoundException(id, boss_bars.keySet());
            }
            catch (Throwable ex) {
                throw new BossNotFoundException(id, boss_bars.keySet());
            }
        }
    }
}

