/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bukkit.region;

import com.bergerkiller.bukkit.common.events.EntityMoveEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import ml.karmaconfigs.api.bukkit.KarmaPlugin;
import ml.karmaconfigs.api.bukkit.region.DummyListener;
import ml.karmaconfigs.api.bukkit.region.corner.util.Corner;
import ml.karmaconfigs.api.bukkit.region.wall.util.Wall;
import ml.karmaconfigs.api.bukkit.region.wall.util.WallType;
import ml.karmaconfigs.api.common.ResourceDownloader;
import ml.karmaconfigs.api.common.karma.KarmaAPI;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.karma.loader.BruteLoader;
import ml.karmaconfigs.api.common.karma.loader.component.NameComponent;
import ml.karmaconfigs.api.common.utils.URLUtils;
import ml.karmaconfigs.api.common.utils.enums.Level;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public abstract class Cuboid
implements Serializable {
    private static boolean tried = false;
    private static Plugin hooked = null;
    private static Listener dummy = null;
    private static final Set<Cuboid> regions = new HashSet<Cuboid>();

    public Cuboid(KarmaPlugin plugin) {
        KarmaSource source = KarmaAPI.source(false);
        PluginManager manager = plugin.getServer().getPluginManager();
        if (!manager.isPluginEnabled(hooked)) {
            if (hooked != null && dummy != null) {
                EntityMoveEvent.getHandlerList().unregister(dummy);
            }
            boolean proceed = true;
            if (!manager.isPluginEnabled("BKCommonLib") && !tried) {
                tried = true;
                source.console().send((CharSequence)"KarmaAPI region API needs BKCommonLib to work but we didn't found it. We will download it", Level.GRAVE);
                File pluginsFolder = new File(plugin.getServer().getWorldContainer(), "plugins");
                File destination = new File(pluginsFolder, "BKCommonLib.jar");
                ResourceDownloader downloader = new ResourceDownloader(destination, "https://karmadev.es/dl/bkcommonlib/plugin.jar");
                downloader.download();
                try {
                    Plugin result = manager.loadPlugin(destination);
                    if (result != null) {
                        source.console().send("&aDownloaded and enabled BKCommonLib");
                    } else {
                        source.console().send("&cBKCommonLib has been downloaded but couldn't be enabled");
                        proceed = false;
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    proceed = false;
                }
            }
            if (proceed) {
                source.console().send((CharSequence)"KarmaAPI region API needs Plexus Common Utilities. We will download it if its not downloaded yet", Level.GRAVE);
                BruteLoader loader = new BruteLoader((URLClassLoader)plugin.getClass().getClassLoader());
                URL url = URLUtils.getOrNull("https://repo1.maven.org/maven2/org/codehaus/plexus/plexus-utils/3.4.1/plexus-utils-3.4.1.jar");
                if (url != null) {
                    loader.downloadAndInject(url, NameComponent.forFile("PlexusCommonUtilities", "jar", new String[0]));
                    dummy = new DummyListener((Plugin)plugin);
                    hooked = plugin;
                    manager.registerEvents(dummy, (Plugin)plugin);
                } else {
                    source.console().send((CharSequence)"Failed to download Plexus Common Utilities because its download URL was null", Level.GRAVE);
                }
            }
        }
        regions.add(this);
    }

    public abstract UUID getUniqueId();

    public abstract String getName();

    public abstract String getInternalName();

    public abstract boolean exists(KarmaPlugin var1);

    public abstract Iterator<Block> getBlocks();

    public abstract Location getCenter();

    public abstract double getSize();

    public abstract double getSizeSquared();

    public abstract Location getTop();

    public abstract Location getBottom();

    public abstract World getWorld();

    public abstract int getBlocksAmount();

    public abstract int getHeight();

    public abstract int getWidth();

    public abstract int getLength();

    public abstract boolean isInside(Entity var1);

    public abstract boolean isInside(Block var1);

    public abstract boolean isInside(Entity var1, double var2);

    public abstract String getToken();

    public abstract Corner getTopCorners();

    public abstract Corner getBottomCorners();

    public abstract Wall getWalls(WallType var1);

    public abstract void saveToMemory(KarmaPlugin var1);

    public static Set<Cuboid> getRegions() {
        return regions;
    }
}

