/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bukkit.region;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import ml.karmaconfigs.api.bukkit.KarmaPlugin;
import ml.karmaconfigs.api.bukkit.region.Cuboid;
import ml.karmaconfigs.api.bukkit.region.corner.BottomCorner;
import ml.karmaconfigs.api.bukkit.region.corner.TopCorner;
import ml.karmaconfigs.api.bukkit.region.corner.util.Corner;
import ml.karmaconfigs.api.bukkit.region.error.RegionNotFound;
import ml.karmaconfigs.api.bukkit.region.wall.RegionWall;
import ml.karmaconfigs.api.bukkit.region.wall.util.Wall;
import ml.karmaconfigs.api.bukkit.region.wall.util.WallType;
import ml.karmaconfigs.api.common.karmafile.KarmaFile;
import ml.karmaconfigs.api.common.utils.security.token.TokenGenerator;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;

public class Region
extends Cuboid
implements Serializable {
    private final String name;
    private final String internal;
    private final String token = TokenGenerator.generateLiteral(16);
    private final int xMin;
    private final int xMax;
    private final int yMin;
    private final int yMax;
    private final int zMin;
    private final int zMax;
    private final double xMinCentered;
    private final double xMaxCentered;
    private final double yMinCentered;
    private final double yMaxCentered;
    private final double zMinCentered;
    private final double zMaxCentered;
    private final UUID uniqueId;
    private final UUID worldId;

    Region(KarmaPlugin owner, Region source) {
        super(owner);
        this.name = source.name;
        this.internal = source.internal;
        this.xMin = source.xMin;
        this.xMax = source.xMax;
        this.yMin = source.yMin;
        this.yMax = source.yMax;
        this.zMin = source.zMin;
        this.zMax = source.zMax;
        this.xMinCentered = source.xMinCentered;
        this.xMaxCentered = source.xMaxCentered;
        this.yMinCentered = source.yMinCentered;
        this.yMaxCentered = source.yMaxCentered;
        this.zMinCentered = source.zMinCentered;
        this.zMaxCentered = source.zMaxCentered;
        this.uniqueId = source.uniqueId;
        this.worldId = source.worldId;
    }

    public Region(KarmaPlugin owner, String n, Location point1, Location point2) throws IllegalArgumentException {
        super(owner);
        this.name = n;
        StringBuilder internalNameBuilder = new StringBuilder();
        String stripped = StringUtils.stripColor(n);
        boolean lastWasSpace = false;
        for (int i = 0; i < stripped.length(); ++i) {
            char character = stripped.charAt(i);
            if (Character.isLetterOrDigit(character) || character == '_') {
                internalNameBuilder.append(character);
                lastWasSpace = character == '_';
                continue;
            }
            if (!Character.isSpaceChar(character) || lastWasSpace) continue;
            internalNameBuilder.append('_');
            lastWasSpace = true;
        }
        this.internal = internalNameBuilder.toString().toLowerCase();
        this.uniqueId = UUID.nameUUIDFromBytes(("Region:" + this.internal).getBytes());
        this.xMin = Math.min(point1.getBlockX(), point2.getBlockX());
        this.xMax = Math.max(point1.getBlockX(), point2.getBlockX());
        this.yMin = Math.min(point1.getBlockY(), point2.getBlockY());
        this.yMax = Math.max(point1.getBlockY(), point2.getBlockY());
        this.zMin = Math.min(point1.getBlockZ(), point2.getBlockZ());
        this.zMax = Math.max(point1.getBlockZ(), point2.getBlockZ());
        this.xMinCentered = (double)this.xMin + 0.5;
        this.xMaxCentered = (double)this.xMax + 0.5;
        this.yMinCentered = (double)this.yMin + 0.5;
        this.yMaxCentered = (double)this.yMax + 0.5;
        this.zMinCentered = (double)this.zMin + 0.5;
        this.zMaxCentered = (double)this.zMax + 0.5;
        if (point1.getWorld() == null || point2.getWorld() == null || !point1.getWorld().getUID().equals(point2.getWorld().getUID())) {
            throw new IllegalArgumentException("Cannot initialize because point1 or point2 location world's are null or not the same");
        }
        this.worldId = point1.getWorld().getUID();
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getInternalName() {
        return this.internal;
    }

    @Override
    public boolean exists(KarmaPlugin owner) {
        KarmaFile file;
        Path regionFile = owner.getDataPath().resolve("cache").resolve("regions").resolve(this.token + ".region");
        if (Files.exists(regionFile, new LinkOption[0]) && (file = new KarmaFile(regionFile)).isSet("REGION")) {
            String result = file.getString("REGION", "");
            Object serialized = StringUtils.load(result);
            return serialized instanceof Region;
        }
        return false;
    }

    @Override
    public Iterator<Block> getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>(this.getBlocksAmount());
        World world = Bukkit.getWorld((UUID)this.worldId);
        if (world != null) {
            for (int x = this.xMin; x <= this.xMax; ++x) {
                for (int y = this.yMin; y <= this.yMax; ++y) {
                    for (int z = this.zMin; z <= this.zMax; ++z) {
                        Block block = world.getBlockAt(x, y, z);
                        blocks.add(block);
                    }
                }
            }
        }
        return blocks.iterator();
    }

    @Override
    public Location getCenter() {
        World world = Bukkit.getWorld((UUID)this.worldId);
        return new Location(world, (double)(this.xMax - this.xMin) / 2.0 + (double)this.xMin, (double)(this.yMax - this.yMin) / 2.0 + (double)this.yMin, (double)(this.zMax - this.zMin) / 2.0 + (double)this.zMin);
    }

    @Override
    public double getSize() {
        return this.getBottom().distance(this.getTop());
    }

    @Override
    public double getSizeSquared() {
        return this.getBottom().distanceSquared(this.getTop());
    }

    @Override
    public Location getTop() {
        World world = Bukkit.getWorld((UUID)this.worldId);
        return new Location(world, (double)this.xMax, (double)this.yMax, (double)this.zMax);
    }

    @Override
    public Location getBottom() {
        World world = Bukkit.getWorld((UUID)this.worldId);
        return new Location(world, (double)this.xMin, (double)this.yMin, (double)this.zMin);
    }

    @Override
    public World getWorld() {
        return Bukkit.getWorld((UUID)this.worldId);
    }

    @Override
    public int getBlocksAmount() {
        return this.getHeight() * this.getWidth() * this.getLength();
    }

    @Override
    public int getHeight() {
        return this.yMax - this.yMin + 1;
    }

    @Override
    public int getWidth() {
        return this.xMax - this.xMin + 1;
    }

    @Override
    public int getLength() {
        return this.zMax - this.zMin + 1;
    }

    @Override
    public boolean isInside(Entity entity) {
        Location loc = entity.getLocation();
        World world = Bukkit.getWorld((UUID)this.worldId);
        return loc.getWorld() == world && loc.getBlockX() >= this.xMin && loc.getBlockX() <= this.xMax && loc.getBlockY() >= this.yMin && loc.getBlockY() <= this.yMax && loc.getBlockZ() >= this.zMin && loc.getBlockZ() <= this.zMax;
    }

    @Override
    public boolean isInside(Block block) {
        World world = Bukkit.getWorld((UUID)this.worldId);
        return block.getWorld() == world && block.getX() >= this.xMin && block.getX() <= this.xMax && block.getY() >= this.yMin && block.getY() <= this.yMax && block.getZ() >= this.zMin && block.getZ() <= this.zMax;
    }

    @Override
    public boolean isInside(Entity entity, double marge) {
        Location loc = entity.getLocation();
        World world = Bukkit.getWorld((UUID)this.worldId);
        return loc.getWorld() == world && loc.getX() >= this.xMinCentered - marge && loc.getX() <= this.xMaxCentered + marge && loc.getY() >= this.yMinCentered - marge && loc.getY() <= this.yMaxCentered + marge && loc.getZ() >= this.zMinCentered - marge && loc.getZ() <= this.zMaxCentered + marge;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public Corner getTopCorners() {
        return new TopCorner(this);
    }

    @Override
    public Corner getBottomCorners() {
        return new BottomCorner(this);
    }

    @Override
    public Wall getWalls(WallType type) {
        return new RegionWall(type, this);
    }

    @Override
    public void saveToMemory(KarmaPlugin owner) {
        if (!this.exists(owner)) {
            Path regionFile = owner.getDataPath().resolve("cache").resolve("regions").resolve(this.token + ".region");
            KarmaFile file = new KarmaFile(regionFile);
            file.set("REGION", StringUtils.serialize(this));
        }
    }

    public static Region fromMemory(KarmaPlugin owner, String token) throws RegionNotFound {
        Path regionFile = owner.getDataPath().resolve("cache").resolve("regions").resolve(token + ".region");
        Region region = null;
        String reason = "";
        if (Files.exists(regionFile, new LinkOption[0])) {
            KarmaFile file = new KarmaFile(regionFile);
            if (file.isSet("REGION")) {
                String result = file.getString("REGION", "");
                Object serialized = StringUtils.load(result);
                if (serialized instanceof Region) {
                    region = (Region)serialized;
                } else {
                    reason = "Region file does not contain valid region data";
                }
            } else {
                reason = "Region file does not contain region data";
            }
        } else {
            reason = "Region file does not exist";
        }
        if (region != null) {
            return new Region(owner, region);
        }
        throw new RegionNotFound(owner, token, reason);
    }
}

