/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bukkit.region.wall;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import ml.karmaconfigs.api.bukkit.region.Cuboid;
import ml.karmaconfigs.api.bukkit.region.wall.util.Wall;
import ml.karmaconfigs.api.bukkit.region.wall.util.WallType;
import ml.karmaconfigs.api.bukkit.util.BlockUtil;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public final class RegionWall
extends Wall {
    private final WallType type;
    private final Cuboid region;

    public RegionWall(WallType t, Cuboid r) {
        this.type = t;
        this.region = r;
    }

    @Override
    public WallType getType() {
        return this.type;
    }

    @Override
    public Cuboid getRegion() {
        return this.region;
    }

    @Override
    public Set<Block> getWall() {
        Location bottom = this.region.getBottom();
        Location top = this.region.getTop();
        switch (this.type) {
            case LEFT: {
                if (bottom.getX() < top.getX()) {
                    top.setX(bottom.getX());
                    break;
                }
                bottom.setX(top.getX());
                break;
            }
            case FRONT: {
                if (bottom.getZ() < top.getZ()) {
                    bottom.setZ(top.getZ());
                    break;
                }
                top.setZ(bottom.getZ());
                break;
            }
            case RIGHT: {
                if (bottom.getX() < top.getX()) {
                    bottom.setX(top.getX());
                    break;
                }
                top.setX(bottom.getX());
                break;
            }
            case BACK: {
                if (bottom.getZ() < top.getZ()) {
                    top.setZ(bottom.getZ());
                    break;
                }
                bottom.setZ(top.getZ());
                break;
            }
            case BOTTOM: {
                top.setY(bottom.getY());
                break;
            }
            case TOP: {
                bottom.setY(top.getY());
                break;
            }
        }
        return BlockUtil.getBlocksBetween(bottom, top);
    }

    @Override
    public Set<Entity> getNear(double range) {
        HashSet<Entity> entities = new HashSet<Entity>();
        this.getWall().forEach(block -> {
            World world = block.getWorld();
            Location location = block.getLocation();
            entities.addAll(world.getNearbyEntities(location, range, range, range));
        });
        return entities;
    }

    @Override
    public Set<Entity> getNear(double range, EntityType ... filter) {
        HashSet<Entity> entities = new HashSet<Entity>();
        HashSet<EntityType> ignore = new HashSet<EntityType>(Arrays.asList(filter));
        this.getWall().forEach(block -> {
            World world = block.getWorld();
            Location location = block.getLocation();
            world.getNearbyEntities(location, range, range, range).forEach(entity -> {
                if (!ignore.contains(entity.getType())) {
                    entities.add((Entity)entity);
                }
            });
        });
        return entities;
    }
}

