/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bukkit.scheduler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import ml.karmaconfigs.api.bukkit.KarmaPlugin;
import ml.karmaconfigs.api.bukkit.scheduler.SchedulerData;
import ml.karmaconfigs.api.common.timer.scheduler.Scheduler;
import org.bukkit.scheduler.BukkitScheduler;

public class BukkitAsyncScheduler<T extends KarmaPlugin>
extends Scheduler {
    private static final Map<KarmaPlugin, SchedulerData> tasks = new ConcurrentHashMap<KarmaPlugin, SchedulerData>();
    private final T instance;

    public BukkitAsyncScheduler(T source) {
        SchedulerData data;
        this.instance = source;
        SchedulerData tmpData = tasks.getOrDefault(source, null);
        if (tmpData == null) {
            tmpData = new SchedulerData();
            tasks.put((KarmaPlugin)source, tmpData);
        }
        if ((data = tmpData).getScheduler() == null) {
            BukkitScheduler scheduler = source.getServer().getScheduler();
            scheduler.runTaskTimerAsynchronously(source, () -> {
                int next = data.getCurrentId() + 1;
                Runnable runnable = data.getTask(next);
                if (runnable != null) {
                    if (data.onTaskStart() != null) {
                        data.onTaskStart().accept(next);
                    }
                    runnable.run();
                    data.updateId(next);
                    if (data.onTaskEnd() != null) {
                        data.onTaskEnd().accept(next);
                    }
                }
            }, 0L, 20L);
            data.updateScheduler(scheduler);
        }
    }

    @Override
    public final void onTaskStart(Consumer<Integer> taskId) {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaPlugin)this.instance, data);
        }
        data.taskStart = taskId;
    }

    @Override
    public final void onTaskComplete(Consumer<Integer> taskId) {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaPlugin)this.instance, data);
        }
        data.taskEnd = taskId;
    }

    @Override
    public final int queue(Runnable task) {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaPlugin)this.instance, data);
        }
        return data.addTask(task);
    }

    @Override
    public final int currentTask() {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaPlugin)this.instance, data);
        }
        return data.getCurrentId();
    }

    public final boolean hasMoreTasks() {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaPlugin)this.instance, data);
        }
        return data.hasNext();
    }
}

