/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bukkit.server;

import ml.karmaconfigs.api.bukkit.server.Version;
import ml.karmaconfigs.api.common.utils.string.ComparatorBuilder;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import ml.karmaconfigs.api.common.utils.string.VersionComparator;
import ml.karmaconfigs.api.common.utils.string.util.VersionDiff;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BukkitServer {
    private static final Server server = Bukkit.getServer();

    public static String getRealVersion() {
        return server.getBukkitVersion();
    }

    public static String getFullVersion() {
        return server.getBukkitVersion().split("-")[0];
    }

    public static String getPackageType() {
        return server.getBukkitVersion().split("-")[2];
    }

    public static String getPackageBuild() {
        return server.getBukkitVersion().split("-")[1];
    }

    public static float getVersion() {
        String[] versionData = server.getBukkitVersion().split("-");
        String version_head = versionData[0].split("\\.")[0];
        String version_sub = versionData[0].split("\\.")[1];
        return Float.parseFloat(version_head + "." + version_sub);
    }

    public static int getVersionUpdate() {
        String[] versionData = server.getBukkitVersion().split("-");
        String version = versionData[0];
        if ((versionData = version.split("\\.")).length >= 3) {
            return Integer.parseInt(versionData[2]);
        }
        return -1;
    }

    public static Version version() {
        String full = BukkitServer.getFullVersion();
        full = "v" + full.replace(".", "_");
        return Version.valueOf(full);
    }

    public static boolean isOver(Version version) {
        String current_version = BukkitServer.version().name().replace("v", "").replace("_", ".");
        String check_version = version.name().replace("v", "").replace("_", ".");
        ComparatorBuilder builder = VersionComparator.createBuilder().currentVersion(current_version).checkVersion(check_version);
        VersionComparator comparator = StringUtils.compareTo(builder);
        return comparator.getDifference().equals((Object)VersionDiff.OVERDATED);
    }

    public static boolean isUpdated(Version version) {
        String current_version = BukkitServer.version().name().replace("v", "").replace("_", ".");
        String check_version = version.name().replace("v", "").replace("_", ".");
        ComparatorBuilder builder = VersionComparator.createBuilder().currentVersion(current_version).checkVersion(check_version);
        VersionComparator comparator = StringUtils.compareTo(builder);
        return comparator.getDifference().equals((Object)VersionDiff.UPDATED);
    }

    public static boolean isUnder(Version v) {
        String current_version = BukkitServer.version().name().replace("v", "").replace("_", ".");
        String check_version = v.name().replace("v", "").replace("_", ".");
        ComparatorBuilder builder = VersionComparator.createBuilder().currentVersion(current_version).checkVersion(check_version);
        VersionComparator comparator = StringUtils.compareTo(builder);
        return comparator.getDifference().equals((Object)VersionDiff.OUTDATED);
    }

    @Nullable
    public static Class<?> getMinecraftClass(@NotNull String clazz) {
        try {
            String version = server.getClass().getPackage().getName().replace(".", ",").split(",")[3];
            return Class.forName("net.minecraft.server." + version + "." + clazz);
        }
        catch (Throwable ex) {
            try {
                return Class.forName("net.minecraft.server." + clazz);
            }
            catch (Throwable exc) {
                return null;
            }
        }
    }

    @Nullable
    public static Class<?> getBukkitClass(@NotNull String clazz) {
        try {
            String version = server.getClass().getPackage().getName().replace(".", ",").split(",")[3];
            return Class.forName("org.bukkit.craftbukkit." + version + "." + clazz);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

