/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bukkit.util;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public final class BlockUtil {
    public static Set<Block> getBlocksBetween(Location loc1, Location loc2) throws IllegalArgumentException {
        World world1 = loc1.getWorld();
        World world2 = loc2.getWorld();
        if (world1 != null && world2 != null && world1.getUID().equals(world2.getUID())) {
            int zMax;
            int zMin;
            int yMax;
            int yMin;
            int xMax;
            int xMin;
            Set<Block> blocks = Collections.newSetFromMap(new ConcurrentHashMap());
            int x1 = loc1.getBlockX();
            int y1 = loc1.getBlockY();
            int z1 = loc1.getBlockZ();
            int x2 = loc2.getBlockX();
            int y2 = loc2.getBlockY();
            int z2 = loc2.getBlockZ();
            if (x1 > x2) {
                xMin = x2;
                xMax = x1;
            } else {
                xMin = x1;
                xMax = x2;
            }
            if (y1 > y2) {
                yMin = y2;
                yMax = y1;
            } else {
                yMin = y1;
                yMax = y2;
            }
            if (z1 > z2) {
                zMin = z2;
                zMax = z1;
            } else {
                zMin = z1;
                zMax = z2;
            }
            for (int x = xMin; x <= xMax; ++x) {
                for (int y = yMin; y <= yMax; ++y) {
                    for (int z = zMin; z <= zMax; ++z) {
                        Block b = new Location(loc1.getWorld(), (double)x, (double)y, (double)z).getBlock();
                        blocks.add(b);
                    }
                }
            }
            return blocks;
        }
        throw new IllegalArgumentException("Cannot get blocks between two locations because one or both of them world is null or does not match ( not in the same world )");
    }

    public static Block getLowestBlockAt(Location location, boolean acceptLiquid) {
        int y = (int)location.getY();
        Block block = location.getBlock().getRelative(BlockFace.DOWN);
        Location tmp = block.getLocation();
        if (!acceptLiquid) {
            do {
                tmp.setY((double)(--y));
            } while (((block = tmp.getBlock()).getType().equals((Object)Material.AIR) || block.getType().equals((Object)Material.WATER) || block.getType().equals((Object)Material.LAVA)) && y > -60);
        } else {
            do {
                tmp.setY((double)(--y));
            } while ((block = tmp.getBlock()).getType().equals((Object)Material.AIR) && y > -60);
        }
        return block;
    }
}

