/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bukkit.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.api.bukkit.KarmaPlugin;
import ml.karmaconfigs.api.bukkit.reflection.BarMessage;
import ml.karmaconfigs.api.bukkit.reflection.TitleMessage;
import ml.karmaconfigs.api.bukkit.util.Client;
import ml.karmaconfigs.api.common.karma.KarmaAPI;
import ml.karmaconfigs.api.common.utils.placeholder.GlobalPlaceholderEngine;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import org.bukkit.entity.Player;

public class BukkitClient
extends Client {
    private static final Set<KarmaPlugin> placeholders = Collections.newSetFromMap(new ConcurrentHashMap());
    private final KarmaPlugin plugin;
    private final Player player;

    public BukkitClient(KarmaPlugin owner, Player client) {
        this.plugin = owner;
        this.player = client;
    }

    @Override
    public void sendMessage(String message) {
        if (placeholders.contains(this.plugin)) {
            GlobalPlaceholderEngine engine = new GlobalPlaceholderEngine(this.plugin);
            message = engine.parse(message, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(false));
            message = engine.parse(message, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(true));
            message = engine.parse(message, this.player);
        }
        this.player.sendMessage(StringUtils.toColor(message));
    }

    @Override
    public void sendMessage(String message, Object ... replaces) {
        if (placeholders.contains(this.plugin)) {
            GlobalPlaceholderEngine engine = new GlobalPlaceholderEngine(this.plugin);
            message = engine.parse(message, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(false));
            message = engine.parse(message, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(true));
            message = engine.parse(message, this.player);
        }
        this.player.sendMessage(StringUtils.toColor(StringUtils.formatString((CharSequence)message, replaces)));
    }

    @Override
    public void sendTitle(String title, String subtitle) {
        if (placeholders.contains(this.plugin)) {
            GlobalPlaceholderEngine engine = new GlobalPlaceholderEngine(this.plugin);
            title = engine.parse(title, this.player);
            subtitle = engine.parse(subtitle, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(false));
            title = engine.parse(title, this.player);
            subtitle = engine.parse(subtitle, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(true));
            title = engine.parse(title, this.player);
            subtitle = engine.parse(subtitle, this.player);
        }
        TitleMessage message = new TitleMessage(this.player, title, subtitle);
        message.send();
    }

    @Override
    public void sendTitle(String title, String subtitle, int showIn, int keepIn, int hideIn) {
        if (placeholders.contains(this.plugin)) {
            GlobalPlaceholderEngine engine = new GlobalPlaceholderEngine(this.plugin);
            title = engine.parse(title, this.player);
            subtitle = engine.parse(subtitle, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(false));
            title = engine.parse(title, this.player);
            subtitle = engine.parse(subtitle, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(true));
            title = engine.parse(title, this.player);
            subtitle = engine.parse(subtitle, this.player);
        }
        TitleMessage message = new TitleMessage(this.player, title, subtitle);
        message.send(showIn, keepIn, hideIn);
    }

    @Override
    public void sendActionBar(String message, int repeats) {
        if (placeholders.contains(this.plugin)) {
            GlobalPlaceholderEngine engine = new GlobalPlaceholderEngine(this.plugin);
            message = engine.parse(message, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(false));
            message = engine.parse(message, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(true));
            message = engine.parse(message, this.player);
        }
        BarMessage bar = new BarMessage(this.player, message);
        bar.send(repeats);
    }

    @Override
    public void sendActionBar(String message, boolean persistent) {
        if (placeholders.contains(this.plugin)) {
            GlobalPlaceholderEngine engine = new GlobalPlaceholderEngine(this.plugin);
            message = engine.parse(message, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(false));
            message = engine.parse(message, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(true));
            message = engine.parse(message, this.player);
        }
        BarMessage bar = new BarMessage(this.player, message);
        bar.send(persistent);
    }

    @Override
    public void disconnect(List<String> reason) {
        if (placeholders.contains(this.plugin)) {
            GlobalPlaceholderEngine engine = new GlobalPlaceholderEngine(this.plugin);
            reason = engine.parse(reason, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(false));
            reason = engine.parse(reason, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(true));
            reason = engine.parse(reason, this.player);
        }
        this.player.kickPlayer(StringUtils.toColor(StringUtils.listToString(reason, false)));
    }

    @Override
    public void disconnect(String ... reason) {
        if (placeholders.contains(this.plugin)) {
            GlobalPlaceholderEngine engine = new GlobalPlaceholderEngine(this.plugin);
            reason = engine.parse(reason, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(false));
            reason = engine.parse(reason, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(true));
            reason = engine.parse(reason, this.player);
        }
        this.player.kickPlayer(StringUtils.toColor(StringUtils.listToString(Arrays.asList(reason), false)));
    }

    @Override
    public void disconnect(String reason) {
        if (placeholders.contains(this.plugin)) {
            GlobalPlaceholderEngine engine = new GlobalPlaceholderEngine(this.plugin);
            reason = engine.parse(reason, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(false));
            reason = engine.parse(reason, this.player);
            engine = new GlobalPlaceholderEngine(KarmaAPI.source(true));
            reason = engine.parse(reason, this.player);
        }
        this.player.kickPlayer(StringUtils.toColor(reason));
    }

    public void setPlaceholders(boolean status) {
        if (status) {
            placeholders.add(this.plugin);
        } else {
            placeholders.remove(this.plugin);
        }
    }

    public boolean hasPlaceholders() {
        return placeholders.contains(this.plugin);
    }
}

