/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bukkit.util.spigot;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.net.URL;
import ml.karmaconfigs.api.bukkit.util.spigot.Request;
import ml.karmaconfigs.api.bukkit.util.spigot.VarType;
import ml.karmaconfigs.api.common.utils.URLUtils;

public final class SpigotRequest {
    private static final Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
    private Request method = Request.DEFAULT;

    public SpigotRequest request(Request request) {
        this.method = request;
        return this;
    }

    public JsonElement push() throws IllegalStateException {
        URL url;
        switch (this.method) {
            case DEFAULT: 
            case LIST_RESOURCES: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=listResources");
                break;
            }
            case LIST_CATEGORIES: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=listResourceCategories");
                break;
            }
            default: {
                throw new IllegalStateException("Cannot push empty data to request " + this.method.name());
            }
        }
        if (url != null) {
            String response = URLUtils.getResponse(url);
            if (response != null) {
                return (JsonElement)gson.fromJson(response, JsonElement.class);
            }
            throw new IllegalStateException("Fetched request " + this.method.name() + " but response was null");
        }
        throw new IllegalStateException("Couldn't fetch for request " + this.method.name() + " because URL is null");
    }

    public JsonElement push(int data) throws IllegalStateException {
        URL url;
        switch (this.method) {
            case DEFAULT: 
            case GET_RESOURCE: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=getResource&id=" + data);
                break;
            }
            case GET_BY_AUTHOR: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=getResourcesByAuthor&id=" + data);
                break;
            }
            case LIST_CATEGORIES: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=listResourceCategories");
                break;
            }
            case GET_UPDATE: {
                url = URLUtils.getOrNull("ttps://api.spigotmc.org/simple/0.2/index.php?action=getResourceUpdate&id=" + data);
                break;
            }
            case GET_UPDATES: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=getResourceUpdates&id=" + data);
                break;
            }
            case GET_AUTHOR: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=getAuthor&id=" + data);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot push empty data to request " + this.method.name());
            }
        }
        if (url != null) {
            String response = URLUtils.getResponse(url);
            if (response != null) {
                return (JsonElement)gson.fromJson(response, JsonElement.class);
            }
            throw new IllegalStateException("Fetched request " + this.method.name() + " but response was null");
        }
        throw new IllegalStateException("Couldn't fetch for request " + this.method.name() + " because URL is null");
    }

    public JsonElement push(int data, VarType type) throws IllegalStateException {
        URL url;
        switch (this.method) {
            case DEFAULT: 
            case LIST_RESOURCES: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=listResources&" + type.get() + "=" + data);
                break;
            }
            case GET_RESOURCE: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=getResource&id=" + data);
                break;
            }
            case GET_BY_AUTHOR: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=getResourcesByAuthor&id=" + data);
                break;
            }
            case LIST_CATEGORIES: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=listResourceCategories");
                break;
            }
            case GET_UPDATE: {
                url = URLUtils.getOrNull("ttps://api.spigotmc.org/simple/0.2/index.php?action=getResourceUpdate&id=" + data);
                break;
            }
            case GET_UPDATES: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=getResourceUpdates&id=" + data);
                break;
            }
            case GET_AUTHOR: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=getAuthor&id=" + data);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot push empty data to request " + this.method.name());
            }
        }
        if (url != null) {
            String response = URLUtils.getResponse(url);
            if (response != null) {
                return (JsonElement)gson.fromJson(response, JsonElement.class);
            }
            throw new IllegalStateException("Fetched request " + this.method.name() + " but response was null");
        }
        throw new IllegalStateException("Couldn't fetch for request " + this.method.name() + " because URL is null");
    }

    public JsonElement push(int data, int second) throws IllegalStateException {
        URL url;
        switch (this.method) {
            case DEFAULT: 
            case LIST_RESOURCES: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=listResources&cat=" + data + "&page=" + second);
                break;
            }
            case GET_RESOURCE: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=getResource&id=" + data + "&page=" + second);
                break;
            }
            case GET_BY_AUTHOR: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=getResourcesByAuthor&id=" + data + "&page=" + second);
                break;
            }
            case LIST_CATEGORIES: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=listResourceCategories");
                break;
            }
            case GET_UPDATE: {
                url = URLUtils.getOrNull("ttps://api.spigotmc.org/simple/0.2/index.php?action=getResourceUpdate&id=" + data);
                break;
            }
            case GET_UPDATES: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=getResourceUpdates&id=" + data + "&page=" + second);
                break;
            }
            case GET_AUTHOR: {
                url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=getAuthor&id=" + data);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot push empty data to request " + this.method.name());
            }
        }
        if (url != null) {
            String response = URLUtils.getResponse(url);
            if (response != null) {
                return (JsonElement)gson.fromJson(response, JsonElement.class);
            }
            throw new IllegalStateException("Fetched request " + this.method.name() + " but response was null");
        }
        throw new IllegalStateException("Couldn't fetch for request " + this.method.name() + " because URL is null");
    }

    public JsonElement push(String data) throws IllegalStateException {
        if (this.method.equals((Object)Request.FIND_AUTHOR)) {
            URL url = URLUtils.getOrNull("https://api.spigotmc.org/simple/0.2/index.php?action=findAuthor&name=" + data);
            if (url != null) {
                String response = URLUtils.getResponse(url);
                if (response != null) {
                    return (JsonElement)gson.fromJson(response, JsonElement.class);
                }
                throw new IllegalStateException("Fetched request " + this.method.name() + " but response was null");
            }
            throw new IllegalStateException("Couldn't fetch for request " + this.method.name() + " because URL is null");
        }
        throw new IllegalStateException("Cannot push empty data to request " + this.method.name());
    }

    public String pushString() throws IllegalStateException {
        JsonElement element = this.push();
        if (element != null) {
            return gson.toJson(element);
        }
        return "";
    }

    public String pushString(int data) throws IllegalStateException {
        JsonElement element = this.push(data);
        if (element != null) {
            return gson.toJson(element);
        }
        return "";
    }

    public String pushString(int data, VarType type) throws IllegalStateException {
        JsonElement element = this.push(data, type);
        if (element != null) {
            return gson.toJson(element);
        }
        return "";
    }

    public String pushString(int data, int second) throws IllegalStateException {
        JsonElement element = this.push(data, second);
        if (element != null) {
            return gson.toJson(element);
        }
        return "";
    }

    public String pushString(String data) throws IllegalStateException {
        JsonElement element = this.push(data);
        if (element != null) {
            return gson.toJson(element);
        }
        return "";
    }
}

