/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bungee.makeiteasy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.api.bungee.makeiteasy.BarUtil;
import ml.karmaconfigs.api.common.boss.BossColor;
import ml.karmaconfigs.api.common.boss.BossNotFoundException;
import ml.karmaconfigs.api.common.boss.BossProvider;
import ml.karmaconfigs.api.common.boss.BossType;
import ml.karmaconfigs.api.common.boss.ProgressiveBar;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.timer.SourceSecondsTimer;
import ml.karmaconfigs.api.common.timer.scheduler.SimpleScheduler;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public final class BossMessage
extends BossProvider<ProxiedPlayer> {
    private final KarmaSource plugin;
    private String message;
    private final double live_time;
    private static int bars = 0;
    private static final List<BossMessage> b_bars = new ArrayList<BossMessage>();
    private static final Map<Integer, BossMessage> boss_bars = new LinkedHashMap<Integer, BossMessage>();
    private static final Map<Integer, BarUtil> bar_objects = new LinkedHashMap<Integer, BarUtil>();
    private final Set<UUID> shown = Collections.newSetFromMap(new ConcurrentHashMap());
    private BossColor color = BossColor.PURPLE;
    private BossType type = BossType.SOLID;
    private ProgressiveBar progress = ProgressiveBar.NONE;
    private double lived_time = 0.0;
    private boolean cancelled = false;
    private static int total_ids = 0;
    private final int id;
    private SimpleScheduler bar_timer = null;

    public BossMessage(KarmaSource owner, String _message, double duration) {
        this.plugin = owner;
        this.message = _message;
        this.live_time = duration;
        this.id = ++total_ids;
    }

    @Override
    public BossProvider<ProxiedPlayer> color(BossColor newColor) {
        this.color = newColor;
        return this;
    }

    @Override
    public BossProvider<ProxiedPlayer> style(BossType newType) {
        this.type = newType;
        return this;
    }

    @Override
    public BossProvider<ProxiedPlayer> progress(ProgressiveBar type) {
        this.progress = type;
        return this;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    protected void displayBar(Collection<ProxiedPlayer> players) {
        ArrayList<ProxiedPlayer> fixed = new ArrayList<ProxiedPlayer>();
        for (ProxiedPlayer player : players) {
            if (player == null || this.shown.contains(player.getUniqueId())) continue;
            fixed.add(player);
            this.shown.add(player.getUniqueId());
        }
        ++bars;
        if (this.cancelled) {
            this.cancelled = false;
        }
        switch (this.progress) {
            case DOWN: {
                this.lived_time = this.live_time - 1.0;
                break;
            }
            case UP: {
                this.lived_time = 0.0;
            }
        }
        BarUtil bar = BarUtil.builder().color(this.color).style(this.type).player(players.toArray(new ProxiedPlayer[0])).health(1.0f).title(TextComponent.fromLegacyText((String)StringUtils.toColor(this.message))).build();
        bar.setVisible(true);
        bar_objects.put(this.id, bar);
        this.bar_timer = new SourceSecondsTimer(this.plugin, this.live_time, false).cancelUnloaded(false);
        this.bar_timer.endAction(() -> {
            bar.setVisible(false);
            bar.removeAllPlayers();
            boss_bars.remove(this.id);
            bar_objects.remove(this.id);
            for (ProxiedPlayer client : fixed) {
                this.shown.remove(client.getUniqueId());
            }
            --bars;
        }).cancelAction(time -> {
            bar.setVisible(false);
            bar.removeAllPlayers();
            boss_bars.remove(this.id);
            bar_objects.remove(this.id);
            for (ProxiedPlayer client : fixed) {
                this.shown.remove(client.getUniqueId());
            }
            --bars;
        }).start();
        SimpleScheduler hp_timer = new SourceSecondsTimer(this.plugin, this.live_time - 1.0, false).cancelUnloaded(false);
        hp_timer.secondChangeAction(second -> {
            if (!this.cancelled) {
                try {
                    bar.setColor(this.color);
                    bar.setStyle(this.type);
                    switch (this.progress) {
                        case UP: {
                            double life_value = this.lived_time / this.live_time;
                            if (life_value <= 1.0 && life_value >= 0.0) {
                                bar.setHealth((float)life_value);
                                this.lived_time += 1.0;
                                break;
                            }
                            this.cancel();
                            break;
                        }
                        case DOWN: {
                            double life_value = (double)second.intValue() / this.live_time;
                            if (life_value <= 1.0 && life_value >= 0.0) {
                                bar.setHealth((float)life_value);
                                this.lived_time -= 1.0;
                                break;
                            }
                            this.cancel();
                        }
                    }
                }
                catch (Throwable ex) {
                    this.cancel();
                }
            } else {
                this.bar_timer.cancel();
                hp_timer.cancel();
            }
        }).start();
    }

    @Override
    public void scheduleBar(Collection<ProxiedPlayer> players) {
        b_bars.add(this);
        boss_bars.put(this.id, this);
        SimpleScheduler timer = new SourceSecondsTimer(this.plugin, 1, false).cancelUnloaded(false).multiThreading(true);
        timer.periodChangeAction(milli -> {
            if (!b_bars.isEmpty() && this.getBarsAmount() < 4) {
                BossMessage boss = b_bars.get(0);
                boss.displayBar(players);
                b_bars.remove(boss);
            }
        }).start();
    }

    @Override
    public void scheduleBar(ProxiedPlayer player) {
        b_bars.add(this);
        boss_bars.put(this.id, this);
        SimpleScheduler timer = new SourceSecondsTimer(this.plugin, 1, false).cancelUnloaded(false).multiThreading(true);
        timer.periodChangeAction(milli -> {
            if (!b_bars.isEmpty() && this.getBarsAmount() < 4) {
                BossMessage boss = b_bars.get(0);
                boss.displayBar((Collection<ProxiedPlayer>)Collections.singleton(player));
                b_bars.remove(boss);
            }
        }).start();
    }

    @Override
    public int getBarsAmount() {
        return bars;
    }

    @Override
    public int getBarId() {
        return this.id;
    }

    @Override
    public boolean update(String _message, boolean restart) {
        try {
            this.message = _message;
            BarUtil bar = bar_objects.get(this.id);
            bar.setTitle(TextComponent.fromLegacyText((String)StringUtils.toColor(this.message)));
            if (this.bar_timer != null && restart) {
                this.bar_timer.restart();
            }
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    @Override
    public BossProvider<ProxiedPlayer> displayTime(double displayTime) {
        this.cancel();
        return new BossMessage(this.plugin, this.message, displayTime).color(this.color).style(this.type).progress(this.progress);
    }

    @Override
    public boolean isValid() {
        return bar_objects.containsKey(this.id);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public String getTitle() {
        return this.message;
    }

    @Override
    public BossColor getColor() {
        return this.color;
    }

    @Override
    public BossType getStyle() {
        return this.type;
    }

    public static interface getters {
        public static BossProvider<ProxiedPlayer> getByID(int id) throws BossNotFoundException {
            try {
                BossMessage boss;
                if (boss_bars.containsKey(id) && (boss = (BossMessage)boss_bars.getOrDefault(id, null)) != null) {
                    return boss;
                }
                throw new BossNotFoundException(id, boss_bars.keySet());
            }
            catch (Throwable ex) {
                throw new BossNotFoundException(id, boss_bars.keySet());
            }
        }
    }
}

