/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.karma.loader.component;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import ml.karmaconfigs.api.common.utils.file.FileUtilities;
import ml.karmaconfigs.api.common.utils.file.PathUtilities;
import ml.karmaconfigs.api.common.utils.string.StringUtils;

public final class NameComponent {
    private String name;
    private final boolean dir;

    NameComponent(String n, boolean directory) {
        this.name = n;
        this.dir = directory;
    }

    public void addParentStart(String parent) {
        this.name = parent + File.separator + this.name;
    }

    public void addParentEnd(String parent) {
        String[] data = FileUtilities.findParents(this.name);
        StringBuilder builder = new StringBuilder();
        for (String str : data) {
            builder.append(str).append(File.separator);
        }
        builder.append(parent).append(File.separator);
        this.name = builder + this.name;
    }

    public String getName() {
        if (!this.dir) {
            String extension = FileUtilities.getExtension(this.name);
            if (this.name.contains(File.separator)) {
                return FileUtilities.clearParents(this.name.replace("." + extension, ""));
            }
            return this.name.replace("." + extension, "");
        }
        if (this.name.contains(File.separator)) {
            return FileUtilities.clearParents(this.name);
        }
        return this.name;
    }

    public String findExtension() {
        if (!this.dir) {
            return FileUtilities.getExtension(this.name);
        }
        return "";
    }

    public Path getParent(Path start) {
        String[] data;
        if (this.dir) {
            data = FileUtilities.findParents(this.name);
        } else {
            String extension = FileUtilities.getExtension(this.name);
            data = FileUtilities.findParents(this.name.replace("." + extension, ""));
        }
        Path result = start;
        if (data.length > 0) {
            for (String str : data) {
                result = result.resolve(str);
            }
        }
        return result;
    }

    public String[] getParents() {
        if (this.dir) {
            return FileUtilities.findParents(this.name);
        }
        String extension = FileUtilities.getExtension(this.name);
        return FileUtilities.findParents(this.name.replace("." + extension, ""));
    }

    public boolean hasParents() {
        return FileUtilities.findParents(this.name).length > 0;
    }

    public boolean hasExtension() {
        if (!this.dir) {
            String extension = FileUtilities.getExtension(this.name);
            return !StringUtils.isNullOrEmpty(extension);
        }
        return false;
    }

    public boolean isDirectory() {
        return this.dir;
    }

    public static NameComponent fromFile(File file) {
        if (file.isDirectory()) {
            return NameComponent.forDirectory(file.getName());
        }
        String extension = FileUtilities.getExtension(file);
        return NameComponent.forFile(file.getName().replace("." + extension, ""), extension, new String[0]);
    }

    public static NameComponent fromPath(Path file) {
        if (Files.isDirectory(file, new LinkOption[0])) {
            return NameComponent.forDirectory(file.getFileName().toString());
        }
        String extension = PathUtilities.getExtension(file);
        return NameComponent.forFile(file.getFileName().toString().replace("." + extension, ""), extension, new String[0]);
    }

    public static NameComponent forFile(CharSequence name, String extension, String ... subDirectory) {
        StringBuilder nameBuilder = new StringBuilder();
        for (String sub : subDirectory) {
            nameBuilder.append(sub).append(File.separator);
        }
        nameBuilder.append(name);
        return new NameComponent(nameBuilder + "." + extension, false);
    }

    public static NameComponent forDirectory(CharSequence name) {
        return new NameComponent(String.valueOf(name), true);
    }
}

