/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.timer;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import ml.karmaconfigs.api.common.karma.KarmaAPI;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.timer.TimeCondition;
import ml.karmaconfigs.api.common.timer.scheduler.SimpleScheduler;
import ml.karmaconfigs.api.common.timer.scheduler.errors.IllegalTimerAccess;
import ml.karmaconfigs.api.common.timer.scheduler.errors.TimerAlreadyStarted;
import ml.karmaconfigs.api.common.timer.scheduler.errors.TimerNotFound;
import ml.karmaconfigs.api.common.utils.enums.Level;

public final class SourceSecondsTimer
extends SimpleScheduler {
    private static final Map<Integer, SimpleScheduler> timersData = new ConcurrentHashMap<Integer, SimpleScheduler>();
    private static final Map<KarmaSource, Set<Integer>> runningTimers = new ConcurrentHashMap<KarmaSource, Set<Integer>>();
    private final int original;
    private final int id;
    private final KarmaSource source;
    private final Map<Integer, Set<Runnable>> secondsActions = new ConcurrentHashMap<Integer, Set<Runnable>>();
    private final Map<Integer, Set<Consumer<Integer>>> secondsConsumer = new ConcurrentHashMap<Integer, Set<Consumer<Integer>>>();
    private final Map<Integer, Set<Consumer<Long>>> secondsLongConsumer = new ConcurrentHashMap<Integer, Set<Consumer<Long>>>();
    private final Set<Runnable> onEndTasks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Runnable> onStartTasks = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Runnable> onRestartTasks = Collections.newSetFromMap(new ConcurrentHashMap());
    private int back;
    private long period = TimeUnit.SECONDS.toMillis(1L);
    private boolean cancelUnloaded = true;
    private boolean cancel = false;
    private boolean pause = false;
    private boolean restart;
    private boolean temp_restart = false;
    private boolean thread = false;
    private Consumer<Long> pauseAction = null;
    private Consumer<Long> cancelAction = null;

    public SourceSecondsTimer(KarmaSource owner, Number time, boolean autoRestart) {
        super(owner);
        this.source = owner;
        this.restart = autoRestart;
        this.back = this.original = (int)time.longValue();
        this.id = this.getId();
        timersData.put(this.id, this);
    }

    public SourceSecondsTimer(KarmaSource owner, int builtId) throws TimerNotFound, IllegalTimerAccess {
        super(owner);
        SimpleScheduler built = timersData.getOrDefault(builtId, null);
        if (built != null) {
            if (!built.getSource().isSource(owner)) {
                throw new IllegalTimerAccess(owner, built);
            }
        } else {
            throw new TimerNotFound(builtId);
        }
        this.source = built.getSource();
        this.restart = built.autoRestart();
        this.original = (int)built.getOriginalTime();
        this.back = (int)TimeUnit.MILLISECONDS.toSeconds(built.getMillis());
        this.id = builtId;
    }

    public SimpleScheduler cancelUnloaded(boolean status) {
        this.cancelUnloaded = status;
        return this;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    @Override
    public void pause() {
        this.pause = true;
        if (this.pauseAction != null) {
            this.runSecondsLongWithThread(this.pauseAction);
        }
    }

    @Override
    public void start() throws TimerAlreadyStarted {
        Set ids = runningTimers.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        if (ids.contains(this.id)) {
            throw new TimerAlreadyStarted(this);
        }
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                boolean run;
                boolean bl = run = !SourceSecondsTimer.this.cancelUnloaded || KarmaAPI.isLoaded(SourceSecondsTimer.this.source);
                if (run) {
                    if (!SourceSecondsTimer.this.pause) {
                        if (SourceSecondsTimer.this.cancel || SourceSecondsTimer.this.temp_restart) {
                            if (!SourceSecondsTimer.this.temp_restart) {
                                timersData.remove(SourceSecondsTimer.this.id);
                                Set ids = runningTimers.getOrDefault(SourceSecondsTimer.this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
                                ids.remove(SourceSecondsTimer.this.id);
                                runningTimers.put(SourceSecondsTimer.this.source, ids);
                                if (SourceSecondsTimer.this.cancelAction != null) {
                                    SourceSecondsTimer.this.runSecondsLongWithThread(SourceSecondsTimer.this.cancelAction);
                                }
                                SourceSecondsTimer.this.cancel = false;
                                SourceSecondsTimer.this.pause = false;
                                SourceSecondsTimer.this.temp_restart = false;
                                timer.cancel();
                            } else {
                                SourceSecondsTimer.this.back = SourceSecondsTimer.this.original;
                                SourceSecondsTimer.this.onRestartTasks.forEach(task -> SourceSecondsTimer.this.runTaskWithThread(task));
                                SourceSecondsTimer.this.temp_restart = false;
                            }
                        } else {
                            SourceSecondsTimer.this.executeTasks();
                            if (SourceSecondsTimer.this.back > 0) {
                                SourceSecondsTimer.this.back--;
                            } else {
                                SourceSecondsTimer.this.back = SourceSecondsTimer.this.original;
                                if (SourceSecondsTimer.this.restart) {
                                    SourceSecondsTimer.this.onRestartTasks.forEach(task -> SourceSecondsTimer.this.runTaskWithThread(task));
                                    SourceSecondsTimer.this.back = SourceSecondsTimer.this.original;
                                } else {
                                    SourceSecondsTimer.this.onEndTasks.forEach(task -> SourceSecondsTimer.this.runTaskWithThread(task));
                                    timersData.remove(SourceSecondsTimer.this.id);
                                    Set ids = runningTimers.getOrDefault(SourceSecondsTimer.this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
                                    ids.remove(SourceSecondsTimer.this.id);
                                    runningTimers.put(SourceSecondsTimer.this.source, ids);
                                    SourceSecondsTimer.this.cancel = false;
                                    SourceSecondsTimer.this.pause = false;
                                    SourceSecondsTimer.this.temp_restart = false;
                                    timer.cancel();
                                }
                            }
                        }
                    }
                } else {
                    timersData.remove(SourceSecondsTimer.this.id);
                    Set ids = runningTimers.getOrDefault(SourceSecondsTimer.this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
                    ids.remove(SourceSecondsTimer.this.id);
                    runningTimers.put(SourceSecondsTimer.this.source, ids);
                    if (SourceSecondsTimer.this.cancelAction != null) {
                        SourceSecondsTimer.this.runSecondsLongWithThread(SourceSecondsTimer.this.cancelAction);
                    }
                    SourceSecondsTimer.this.cancel = false;
                    SourceSecondsTimer.this.pause = false;
                    SourceSecondsTimer.this.temp_restart = false;
                    timer.cancel();
                    KarmaAPI.source(true).console().send((CharSequence)"Timer task with ID {0} has been cancelled because its source {1} has been unloaded", Level.INFO, SourceSecondsTimer.this.id, SourceSecondsTimer.this.source.name());
                }
            }
        }, 0L, this.period);
    }

    @Override
    public void restart() {
        this.temp_restart = true;
    }

    @Override
    public SimpleScheduler updateAutoRestart(boolean status) {
        this.restart = status;
        return this;
    }

    @Override
    public SimpleScheduler withPeriod(Number time) {
        int seconds;
        String value = time.toString();
        int milli = 0;
        if (value.contains(".")) {
            String[] data = value.split("\\.");
            String first = data[0];
            String millis = value.replaceFirst(first + ".", "");
            seconds = (int)TimeUnit.SECONDS.toMillis(Integer.parseInt(first));
            if (millis.length() != 2) {
                if (millis.length() < 2) {
                    millis = millis + "000";
                }
                milli = Integer.parseInt(millis.substring(0, 2));
            } else {
                milli = Integer.parseInt(millis);
            }
        } else {
            seconds = (int)TimeUnit.SECONDS.toMillis(time.intValue());
        }
        this.period = seconds + milli;
        return this;
    }

    @Override
    public SimpleScheduler multiThreading(boolean status) {
        this.thread = status;
        return this;
    }

    @Override
    public SimpleScheduler exactSecondPeriodAction(int time, Runnable task) {
        Set actions = this.secondsActions.getOrDefault(time, Collections.newSetFromMap(new ConcurrentHashMap()));
        actions.add(task);
        this.secondsActions.put(time, actions);
        return this;
    }

    @Override
    public SimpleScheduler exactPeriodAction(long time, Runnable task) {
        Set actions = this.secondsActions.getOrDefault((int)TimeUnit.MILLISECONDS.toSeconds(time), Collections.newSetFromMap(new ConcurrentHashMap()));
        actions.add(task);
        this.secondsActions.put((int)TimeUnit.MILLISECONDS.toSeconds(time), actions);
        return this;
    }

    @Override
    public SimpleScheduler secondChangeAction(Consumer<Integer> action) {
        int second = this.original;
        while (second >= 0) {
            Set actions = this.secondsConsumer.getOrDefault(second--, Collections.newSetFromMap(new ConcurrentHashMap()));
            actions.add(action);
            this.secondsConsumer.put(second, actions);
        }
        return this;
    }

    @Override
    public SimpleScheduler periodChangeAction(Consumer<Long> action) {
        int second = this.original;
        while (second >= 0) {
            Set actions = this.secondsLongConsumer.getOrDefault(second--, Collections.newSetFromMap(new ConcurrentHashMap()));
            actions.add(action);
            this.secondsLongConsumer.put(second, actions);
        }
        return this;
    }

    @Override
    public SimpleScheduler cancelAction(Consumer<Long> action) {
        this.cancelAction = action;
        return this;
    }

    @Override
    public SimpleScheduler pauseAction(Consumer<Long> action) {
        this.pauseAction = action;
        return this;
    }

    @Override
    public SimpleScheduler startAction(Runnable task) {
        this.onStartTasks.add(task);
        return this;
    }

    @Override
    public SimpleScheduler endAction(Runnable task) {
        this.onEndTasks.add(task);
        return this;
    }

    @Override
    public SimpleScheduler restartAction(Runnable task) {
        this.onRestartTasks.add(task);
        return this;
    }

    @Override
    public SimpleScheduler conditionalAction(TimeCondition condition, int condition_value, Consumer<Integer> action) {
        switch (condition) {
            case EQUALS: {
                Set actions = this.secondsConsumer.getOrDefault(condition_value, Collections.newSetFromMap(new ConcurrentHashMap()));
                actions.add(action);
                this.secondsConsumer.put(condition_value, actions);
                break;
            }
            case OVER_OF: {
                int c_over_val = condition_value;
                while (c_over_val <= this.original) {
                    Set actions = this.secondsConsumer.getOrDefault(c_over_val++, Collections.newSetFromMap(new ConcurrentHashMap()));
                    actions.add(action);
                    this.secondsConsumer.put(c_over_val, actions);
                }
                break;
            }
            case MINUS_TO: {
                int c_minus_val = condition_value;
                while (c_minus_val >= 0) {
                    Set actions = this.secondsConsumer.getOrDefault(c_minus_val--, Collections.newSetFromMap(new ConcurrentHashMap()));
                    actions.add(action);
                    this.secondsConsumer.put(c_minus_val, actions);
                }
                break;
            }
        }
        return this;
    }

    @Override
    public SimpleScheduler conditionalPeriodAction(TimeCondition condition, long condition_value, Consumer<Long> action) {
        int seconds = (int)TimeUnit.MILLISECONDS.toSeconds(condition_value);
        switch (condition) {
            case EQUALS: {
                Set actions = this.secondsLongConsumer.getOrDefault(seconds, Collections.newSetFromMap(new ConcurrentHashMap()));
                actions.add(action);
                this.secondsLongConsumer.put(seconds, actions);
                break;
            }
            case OVER_OF: {
                int c_over_val = seconds;
                while (c_over_val <= this.original) {
                    Set actions = this.secondsLongConsumer.getOrDefault(c_over_val++, Collections.newSetFromMap(new ConcurrentHashMap()));
                    actions.add(action);
                    this.secondsLongConsumer.put(c_over_val, actions);
                }
                break;
            }
            case MINUS_TO: {
                int c_minus_val = seconds;
                while (c_minus_val >= 0) {
                    Set actions = this.secondsLongConsumer.getOrDefault(c_minus_val--, Collections.newSetFromMap(new ConcurrentHashMap()));
                    actions.add(action);
                    this.secondsLongConsumer.put(c_minus_val, actions);
                }
                break;
            }
        }
        return this;
    }

    @Override
    public boolean isCancelled() {
        return this.cancel;
    }

    @Override
    public boolean isRunning() {
        Set ids = runningTimers.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        return ids.contains(this.id);
    }

    @Override
    public boolean isPaused() {
        return this.pause;
    }

    @Override
    public boolean autoRestart() {
        return this.restart;
    }

    @Override
    public boolean isMultiThreading() {
        return this.thread;
    }

    @Override
    public long getOriginalTime() {
        return this.original;
    }

    @Override
    public long getPeriod() {
        return this.period;
    }

    @Override
    public long getMillis() {
        return TimeUnit.SECONDS.toMillis(this.back);
    }

    private void executeTasks() {
        Set secondConsumers = this.secondsConsumer.getOrDefault(this.back, Collections.newSetFromMap(new ConcurrentHashMap()));
        Set secondLongConsumers = this.secondsLongConsumer.getOrDefault(this.back, Collections.newSetFromMap(new ConcurrentHashMap()));
        Set actions = this.secondsActions.getOrDefault(this.back, Collections.newSetFromMap(new ConcurrentHashMap()));
        for (Consumer consumer : secondConsumers) {
            this.runSecondsWithThread(consumer);
        }
        for (Consumer consumer : secondLongConsumers) {
            this.runSecondsLongWithThread(consumer);
        }
        for (Runnable runnable : actions) {
            this.runTaskWithThread(runnable);
        }
    }

    private void runSecondsWithThread(Consumer<Integer> task) {
        if (this.thread) {
            new Thread(() -> task.accept(this.back)).start();
        } else {
            task.accept(this.back);
        }
    }

    private void runSecondsLongWithThread(Consumer<Long> task) {
        if (this.thread) {
            new Thread(() -> task.accept(TimeUnit.SECONDS.toMillis(this.back))).start();
        } else {
            task.accept(TimeUnit.SECONDS.toMillis(this.back));
        }
    }

    private void runTaskWithThread(Runnable task) {
        if (this.thread) {
            new Thread(task).start();
        } else {
            task.run();
        }
    }
}

