/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.timer.worker;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import ml.karmaconfigs.api.common.timer.scheduler.SimpleScheduler;

final class SchedulerData {
    private SimpleScheduler scheduler;
    private int current_id;
    private int last_task_id = 0;
    Consumer<Integer> taskStart = null;
    Consumer<Integer> taskEnd = null;
    private final Map<Integer, Runnable> tasks = new ConcurrentHashMap<Integer, Runnable>();

    SchedulerData() {
    }

    public void updateScheduler(SimpleScheduler s) {
        this.scheduler = s;
    }

    public void updateId(int id) {
        this.current_id = id;
    }

    public int addTask(Runnable tsk) {
        int taskId = ++this.last_task_id;
        this.tasks.put(taskId, tsk);
        return taskId;
    }

    public SimpleScheduler getScheduler() {
        return this.scheduler;
    }

    public int getCurrentId() {
        return this.current_id;
    }

    public Runnable getTask(int id) {
        if (this.tasks.containsKey(id)) {
            return this.tasks.remove(id);
        }
        return null;
    }

    public boolean hasNext() {
        return this.tasks.containsKey(this.current_id + 1);
    }

    public Consumer<Integer> onTaskStart() {
        return this.taskStart;
    }

    public Consumer<Integer> onTaskEnd() {
        return this.taskEnd;
    }
}

