/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.utils;

import java.io.Serializable;
import java.util.HashMap;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class PrefixConsoleData
implements Serializable {
    private static final HashMap<KarmaSource, String> okPrefix = new HashMap();
    private static final HashMap<KarmaSource, String> infoPrefix = new HashMap();
    private static final HashMap<KarmaSource, String> warnPrefix = new HashMap();
    private static final HashMap<KarmaSource, String> gravPrefix = new HashMap();
    private final KarmaSource source;

    public PrefixConsoleData(@NotNull KarmaSource p) {
        this.source = p;
    }

    public void setOkPrefix(@NotNull String prefix) {
        okPrefix.put(this.source, StringUtils.toConsoleColor(prefix));
    }

    public void setInfoPrefix(@NotNull String prefix) {
        infoPrefix.put(this.source, StringUtils.toConsoleColor(prefix));
    }

    public void setWarnPrefix(@NotNull String prefix) {
        warnPrefix.put(this.source, StringUtils.toConsoleColor(prefix));
    }

    public void setGravePrefix(@NotNull String prefix) {
        gravPrefix.put(this.source, StringUtils.toConsoleColor(prefix));
    }

    public String getOkPrefix() {
        return okPrefix.getOrDefault(this.source, StringUtils.toConsoleColor("&b[ &3" + this.source.name() + " &b| &2OK &b] >> &9"));
    }

    public String getInfoPrefix() {
        return infoPrefix.getOrDefault(this.source, StringUtils.toConsoleColor("&b[ &3" + this.source.name() + " &b| &7INFO &b] >> &9"));
    }

    public String getWarningPrefix() {
        return warnPrefix.getOrDefault(this.source, StringUtils.toConsoleColor("&b[ &3" + this.source.name() + " &b| &6WARNING &b] >> &9"));
    }

    public String getGravePrefix() {
        return gravPrefix.getOrDefault(this.source, StringUtils.toConsoleColor("&b[ &3" + this.source.name() + " &b| &cGRAVE &b] >> &9"));
    }
}

