/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Scanner;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.Nullable;

public final class URLUtils {
    public static void fastConnect(URL url) {
        try (CloseableHttpClient httpclient = HttpClients.createDefault();){
            HttpGet httpget = new HttpGet(url.toURI());
            httpclient.execute((HttpUriRequest)httpget);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean exists(String url) {
        return URLUtils.getResponseCode(url) == 200;
    }

    public static int getResponseCode(String url) {
        try {
            HttpURLConnection.setFollowRedirects(false);
            HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
            con.setInstanceFollowRedirects(false);
            con.setRequestMethod("HEAD");
            return con.getResponseCode();
        }
        catch (Throwable e) {
            return 503;
        }
    }

    @Nullable
    public static URL getOrNull(String url) {
        try {
            return new URL(url);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    @Nullable
    public static URL getOrBackup(String def, String ... backup) {
        URL defURL = URLUtils.getOrNull(def);
        if (defURL == null) {
            int trie = 0;
            do {
                defURL = URLUtils.getOrNull(backup[trie]);
            } while (++trie < backup.length);
        }
        return defURL;
    }

    public static String getResponse(URL url) {
        String response = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet httpget = new HttpGet(url.toURI());
            CloseableHttpResponse httpresponse = httpclient.execute((HttpUriRequest)httpget);
            Header[] contentType = httpresponse.getHeaders("Content-type");
            boolean json = false;
            for (Header header : contentType) {
                if (!header.getValue().equalsIgnoreCase("application/json")) continue;
                json = true;
                break;
            }
            Scanner sc = new Scanner(httpresponse.getEntity().getContent());
            StringBuilder sb = new StringBuilder();
            while (sc.hasNext()) {
                sb.append(sc.next());
            }
            response = sb.toString();
            if (json) {
                Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
                JsonElement object = (JsonElement)gson.fromJson(response, JsonElement.class);
                response = gson.toJson(object);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return response;
    }
}

