/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.utils.placeholder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ml.karmaconfigs.api.common.annotations.Unstable;
import ml.karmaconfigs.api.common.karma.KarmaAPI;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.utils.placeholder.util.Placeholder;
import ml.karmaconfigs.api.common.utils.placeholder.util.PlaceholderEngine;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class GlobalPlaceholderEngine
extends PlaceholderEngine {
    private static final Map<KarmaSource, Set<Placeholder<?>>> sourcePlaceholders = new ConcurrentHashMap();
    private static final Map<KarmaSource, Character> open = new ConcurrentHashMap<KarmaSource, Character>();
    private static final Map<KarmaSource, Character> close = new ConcurrentHashMap<KarmaSource, Character>();
    private static final Set<KarmaSource> protect = Collections.newSetFromMap(new ConcurrentHashMap());
    private final KarmaSource source;

    public GlobalPlaceholderEngine(KarmaSource owner) {
        this.source = owner;
    }

    @Override
    public void setOpenIdentifier(char identifier) {
        if (!Character.isLetterOrDigit(identifier) && !Character.isSpaceChar(identifier)) {
            open.put(this.source, Character.valueOf(identifier));
        }
    }

    @Override
    public void setCloseIdentifier(char identifier) {
        if (!Character.isLetterOrDigit(identifier) && !Character.isSpaceChar(identifier)) {
            close.put(this.source, Character.valueOf(identifier));
        }
    }

    @Override
    public void protect() {
        KarmaSource original = KarmaAPI.source(true);
        if (!this.source.equals(original)) {
            protect.add(this.source);
        }
    }

    @Override
    @SafeVarargs
    public final <T> void register(Placeholder<T> ... placeholders) {
        Set registered = sourcePlaceholders.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        HashSet keys = new HashSet();
        registered.forEach(placeholder -> keys.add(placeholder.getKey()));
        for (Placeholder<T> placeholder2 : placeholders) {
            if (placeholder2 == null || keys.contains(placeholder2.getKey())) continue;
            registered.add(placeholder2);
        }
        sourcePlaceholders.put(this.source, registered);
    }

    @Override
    @Unstable(reason="The normal register method should be used instead as this method may register non desired placeholders")
    public void registerUnsafe(Placeholder<?> ... placeholders) {
        Set registered = sourcePlaceholders.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        HashSet keys = new HashSet();
        registered.forEach(placeholder -> keys.add(placeholder.getKey()));
        for (Placeholder<?> placeholder2 : placeholders) {
            if (placeholder2 == null || keys.contains(placeholder2.getKey())) continue;
            registered.add(placeholder2);
        }
        sourcePlaceholders.put(this.source, registered);
    }

    @Override
    @SafeVarargs
    @Unstable(reason="Using this method may register null placeholders which can cause more issues in the future")
    public final <T> void forceRegister(Placeholder<T> ... placeholders) {
        if (!protect.contains(this.source)) {
            Set registered = sourcePlaceholders.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
            registered.addAll(Arrays.asList(placeholders));
            sourcePlaceholders.put(this.source, registered);
        }
    }

    @Override
    public void unregister(String ... placeholders) {
        if (!protect.contains(this.source)) {
            Set registered = sourcePlaceholders.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
            HashSet<String> unregister = new HashSet<String>(Arrays.asList(placeholders));
            registered.forEach(placeholder -> {
                if (placeholder != null && unregister.contains(placeholder.getKey())) {
                    registered.remove(placeholder);
                }
            });
            sourcePlaceholders.put(this.source, registered);
        }
    }

    @Override
    @SafeVarargs
    public final <T> void unregister(Placeholder<T> ... placeholders) {
        if (!protect.contains(this.source)) {
            Set registered = sourcePlaceholders.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
            HashSet<Placeholder<T>> unregister = new HashSet<Placeholder<T>>(Arrays.asList(placeholders));
            registered.removeAll(unregister);
            sourcePlaceholders.put(this.source, registered);
        }
    }

    @Override
    @Unstable(reason="Return method may differ from stored method")
    @Nullable
    public <T> Placeholder<T> getPlaceholder(String key) {
        Set registered = sourcePlaceholders.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        Placeholder result = null;
        for (Placeholder placeholder : registered) {
            if (!placeholder.getKey().equals(key)) continue;
            try {
                result = placeholder;
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    @Override
    public String parse(String message, Object ... containers) {
        String key;
        String name;
        int end;
        int start;
        String startChar = StringUtils.escapeString(String.valueOf(open.getOrDefault(this.source, Character.valueOf('%'))));
        String closeChar = String.valueOf(close.getOrDefault(this.source, Character.valueOf('%')));
        Pattern pattern = Pattern.compile("(" + startChar + ".[^" + closeChar + "]*" + closeChar + ")|(\\{.[^}]*})");
        ConcurrentHashMap<String, String> replaces = new ConcurrentHashMap<String, String>();
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            start = matcher.start();
            end = matcher.end();
            name = message.substring(start + 1, end - 1);
            key = message.substring(start, end);
            replaces.put(name, key);
        }
        if (replaces.isEmpty() && matcher.matches()) {
            start = matcher.start();
            end = matcher.end();
            name = message.substring(start + 1, end - 1);
            key = message.substring(start, end);
            replaces.put(name, key);
        }
        Set registered = sourcePlaceholders.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
        String finalMessage = message;
        for (Placeholder placeholder : registered) {
            String placeholderName;
            String placeholderKey;
            if (placeholder == null || (placeholderKey = (String)replaces.getOrDefault(placeholderName = placeholder.getKey(), null)) == null) continue;
            if (containers.length > 0) {
                for (Object container : containers) {
                    if (container == null || !placeholder.getType().isAssignableFrom(container.getClass())) continue;
                    finalMessage = finalMessage.replace(placeholderKey, String.valueOf(placeholder.getValue(container)));
                }
                continue;
            }
            try {
                finalMessage = finalMessage.replace(placeholderKey, String.valueOf(placeholder.getValue(null)));
            }
            catch (Throwable throwable) {
            }
        }
        return finalMessage;
    }

    @Override
    public List<String> parse(List<String> message, Object ... containers) {
        ArrayList<String> parsed = new ArrayList<String>();
        for (String str : message) {
            parsed.add(this.parse(str, containers));
        }
        return parsed;
    }

    @Override
    public String[] parse(String[] message, Object ... containers) {
        return this.parse(Arrays.asList(message), containers).toArray(new String[0]);
    }

    @Override
    public Set<Placeholder<?>> getKeys() {
        return sourcePlaceholders.getOrDefault(this.source, Collections.newSetFromMap(new ConcurrentHashMap()));
    }
}

