/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.utils.reader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;

public final class BoundedBufferedReader
extends BufferedReader
implements Serializable {
    private final int readerMaxLines;
    private final int readerMaxLineLen;
    private int currentLine = 1;

    public BoundedBufferedReader(Reader reader, int maxLines, int maxLineLen) {
        super(reader);
        if (maxLines <= 0 || maxLineLen <= 0) {
            throw new IllegalArgumentException("BoundedBufferedReader - maxLines and maxLineLen must be greater than 0");
        }
        this.readerMaxLines = maxLines;
        this.readerMaxLineLen = maxLineLen;
    }

    public BoundedBufferedReader(Reader reader) {
        super(reader);
        this.readerMaxLines = 1024;
        this.readerMaxLineLen = 1024;
    }

    @Override
    public String readLine() throws IOException {
        if (this.currentLine > this.readerMaxLines) {
            throw new IOException("BoundedBufferedReader - Line read limit has been reached.");
        }
        ++this.currentLine;
        int currentPos = 0;
        char[] data = new char[this.readerMaxLineLen];
        int currentCharVal = this.read();
        while (currentCharVal != 13 && currentCharVal != 10 && currentCharVal >= 0) {
            data[currentPos++] = (char)currentCharVal;
            if (currentPos >= this.readerMaxLineLen) continue;
            currentCharVal = this.read();
        }
        if (currentCharVal < 0) {
            if (currentPos > 0) {
                return new String(data, 0, currentPos);
            }
            return null;
        }
        if (currentCharVal == 13) {
            this.mark(1);
            if (this.read() != 10) {
                this.reset();
            }
        }
        return new String(data, 0, currentPos);
    }
}

