/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.velocity.loader;

import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.utils.BridgeLoader;
import ml.karmaconfigs.api.common.utils.enums.Level;

public class VelocityBridge
extends BridgeLoader<KarmaSource> {
    private static KarmaSource instance;
    private static ProxyServer server;
    private static PluginContainer plugin;

    public VelocityBridge(KarmaSource source, ProxyServer sv, PluginContainer owner) {
        super("Velocity", source);
        instance = source;
        server = sv;
        plugin = owner;
    }

    @Override
    public void start() {
        plugin.getInstance().ifPresent(pluginI -> {
            instance.console().send((CharSequence)"Initializing Velocity <-> KarmaAPI bridge", Level.INFO);
            this.connect(instance.getSourceFile());
            instance.console().send((CharSequence)"Velocity <-> KarmaAPI bridge made successfully", Level.INFO);
            try {
                for (PluginContainer container : server.getPluginManager().getPlugins()) {
                    if (!container.getDescription().getDependency("anotherbarelycodedkarmaplugin").isPresent()) continue;
                    container.getDescription().getSource().ifPresent(x$0 -> this.connect((Path)x$0));
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        });
    }

    @Override
    public void stop() {
        instance.console().send((CharSequence)"Closing Velocity <-> KarmaAPI bridge, please wait...", Level.INFO);
    }

    public static KarmaSource getSource() {
        return instance;
    }

    public static ProxyServer getServer() {
        return server;
    }
}

