/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bungee.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import ml.karmaconfigs.api.bungee.KarmaPlugin;
import ml.karmaconfigs.api.common.karmafile.karmayaml.KarmaYamlManager;
import ml.karmaconfigs.api.common.utils.BridgeLoader;
import ml.karmaconfigs.api.common.utils.enums.Level;
import ml.karmaconfigs.api.common.utils.file.PathUtilities;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeeBridge
extends BridgeLoader<KarmaPlugin> {
    private static KarmaPlugin instance;
    private static final Set<Plugin> loaded;

    public BungeeBridge(KarmaPlugin source) {
        super("Bungee", source);
        instance = source;
    }

    @Override
    public void start() throws IOException {
        Path plugins = PathUtilities.getProjectParent();
        instance.console().send((CharSequence)"Initializing Bungee <-> KarmaAPI bridge", Level.INFO);
        this.connect(instance.getSourceFile());
        instance.console().send((CharSequence)"Bungee <-> KarmaAPI bridge made successfully", Level.INFO);
        LinkedHashMap load_target = new LinkedHashMap();
        HashSet generated = new HashSet();
        Files.list(plugins).forEachOrdered(sub -> {
            if (!Files.isDirectory(sub, new LinkOption[0]) && PathUtilities.getPathCompleteType(sub).equalsIgnoreCase("jar")) {
                try {
                    InputStream stream;
                    JarFile jar = new JarFile(sub.toFile());
                    ZipEntry plugin = jar.getEntry("plugin.yml");
                    if (plugin != null && (stream = jar.getInputStream(plugin)) != null) {
                        KarmaYamlManager yaml = new KarmaYamlManager(stream);
                        String name = yaml.getString("name", null);
                        List<String> dependencies = yaml.getStringList("softdepends");
                        dependencies.addAll(yaml.getStringList("depends"));
                        if (dependencies.stream().anyMatch(s -> s.equalsIgnoreCase("AnotherBarelyCodedKarmaPlugin"))) {
                            instance.console().send((CharSequence)"Plugin {0} added to Bungee <-> KarmaAPI bridge", Level.INFO, name);
                            if (!load_target.containsKey(name)) {
                                load_target.put(name, sub.toFile());
                            } else {
                                String gen = StringUtils.generateString().create();
                                generated.add(gen);
                                load_target.put(name + "_" + gen, sub.toFile());
                            }
                        }
                        stream.close();
                    }
                    jar.close();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        });
        for (String name : load_target.keySet()) {
            File file = (File)load_target.get(name);
            if (name.contains("_")) {
                try {
                    String[] data = name.split("_");
                    String veryImportantData = data[data.length - 1];
                    if (generated.contains(veryImportantData)) {
                        name = StringUtils.replaceLast(name, "_" + veryImportantData, "");
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            instance.console().send((CharSequence)"Creating bridge between Bungee and KarmaAPI for {0}", Level.INFO, name);
            this.connect(file);
            instance.console().send((CharSequence)"Bridge between Bungee and KarmaAPI created successfully for {0}", Level.OK, name);
        }
    }

    @Override
    public void stop() {
        instance.console().send((CharSequence)"Closing Bungee <-> KarmaAPI bridge, please wait...", Level.INFO);
    }

    public static KarmaPlugin getInstance() {
        return instance;
    }

    static {
        loaded = Collections.newSetFromMap(new ConcurrentHashMap());
    }
}

