/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bungee.makeiteasy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import ml.karmaconfigs.api.common.boss.BossColor;
import ml.karmaconfigs.api.common.boss.BossFlag;
import ml.karmaconfigs.api.common.boss.BossType;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.BossBar;
import org.jetbrains.annotations.NotNull;

final class BarUtil {
    private BaseComponent[] title;
    private BossColor color;
    private BossType style;
    private final Set<BossFlag> flags;
    private float health;
    private final UUID uuid;
    private boolean visible;
    private final List<ProxiedPlayer> players;

    public BarUtil(@NotNull BaseComponent[] title, @NotNull BossColor color, @NotNull BossType style, float health) throws IllegalArgumentException {
        this.title = title;
        this.color = color;
        this.style = style;
        this.health = health;
        this.flags = EnumSet.noneOf(BossFlag.class);
        this.uuid = UUID.randomUUID();
        this.players = new ArrayList<ProxiedPlayer>();
        this.visible = true;
        if (health > 1.0f || (double)health < 0.1) {
            throw new IllegalArgumentException("The boss health must be between 0.1 and 1. Provided: " + health);
        }
    }

    public BarUtil(@NotNull BaseComponent[] title, @NotNull BossColor color, @NotNull BossType style) {
        this(title, color, style, 1.0f);
    }

    public BarUtil(@NotNull BaseComponent[] title) {
        this(title, BossColor.PINK, BossType.SOLID);
    }

    void addPlayers(@NotNull Iterable<ProxiedPlayer> players) {
        for (ProxiedPlayer player : players) {
            this.addPlayer(player);
        }
    }

    void addPlayer(@NotNull ProxiedPlayer player) {
        if (!this.players.contains(player)) {
            this.players.add(player);
        }
        if (player.isConnected() && this.visible) {
            this.sendPacket(player, (DefinedPacket)this.addPacket());
        }
    }

    void removePlayers(ProxiedPlayer ... playerArray) {
        Iterator<ProxiedPlayer> iterator = this.players.iterator();
        HashSet<UUID> uuids = new HashSet<UUID>();
        for (ProxiedPlayer player : playerArray) {
            uuids.add(player.getUniqueId());
        }
        if (iterator.hasNext()) {
            do {
                ProxiedPlayer player;
                if (!uuids.contains((player = iterator.next()).getUniqueId()) || !player.isConnected() || !this.visible) continue;
                this.sendPacket(player, (DefinedPacket)this.removePacket());
                this.players.remove(player);
            } while (iterator.hasNext());
        }
    }

    void removeAllPlayers() {
        Iterator<ProxiedPlayer> iterator = this.players.iterator();
        if (iterator.hasNext()) {
            do {
                ProxiedPlayer player;
                if (!(player = iterator.next()).isConnected() || !this.visible) continue;
                this.sendPacket(player, (DefinedPacket)this.removePacket());
            } while (iterator.hasNext());
        }
        this.players.clear();
    }

    void removePlayer(@NotNull ProxiedPlayer player) {
        if (player.isConnected() && this.visible) {
            this.sendPacket(player, (DefinedPacket)this.removePacket());
        }
        this.players.remove(player);
    }

    void setTitle(BaseComponent ... title) {
        this.title = title;
        if (this.visible) {
            BossBar packet = new BossBar(this.uuid, 3);
            packet.setTitle(ComponentSerializer.toString((BaseComponent[])title));
            this.sendToAffected((DefinedPacket)packet);
        }
    }

    void setHealth(float health) throws IllegalArgumentException {
        if (health > 1.0f || (double)health < 0.1) {
            throw new IllegalArgumentException("The boss health must be between 0.1 and 1. Provided: " + health);
        }
        this.health = health;
        if (this.visible) {
            BossBar packet = new BossBar(this.uuid, 2);
            packet.setHealth(health);
            this.sendToAffected((DefinedPacket)packet);
        }
    }

    void setColor(@NotNull BossColor newColor) {
        if (this.visible) {
            this.color = newColor;
            this.setDivisions(this.color, this.style);
        }
    }

    void setStyle(@NotNull BossType newStyle) {
        if (this.visible) {
            this.style = newStyle;
            this.setDivisions(this.color, this.style);
        }
    }

    void setVisible(boolean visible) {
        boolean previous = this.visible;
        if (previous && !visible) {
            this.sendToAffected((DefinedPacket)this.removePacket());
        } else if (!previous && visible) {
            this.sendToAffected((DefinedPacket)this.addPacket());
        }
        this.visible = visible;
    }

    void addFlags(BossFlag ... flags) {
        if (this.flags.addAll(Arrays.asList(flags)) && this.visible) {
            this.sendToAffected((DefinedPacket)this.updateFlags());
        }
    }

    void removeFlag(@NotNull BossFlag flag) {
        if (this.flags.remove((Object)flag) && this.visible) {
            this.sendToAffected((DefinedPacket)this.updateFlags());
        }
    }

    void removeFlags(BossFlag ... flags) {
        this.removeFlags(Arrays.asList(flags));
    }

    void removeFlags(@NotNull Collection<BossFlag> flags) {
        if (this.flags.removeAll(flags) && this.visible) {
            this.sendToAffected((DefinedPacket)this.updateFlags());
        }
    }

    Collection<ProxiedPlayer> getPlayers() {
        return Collections.unmodifiableList(this.players);
    }

    BaseComponent[] getTitle() {
        return this.title;
    }

    float getHealth() {
        return this.health;
    }

    BossColor getColor() {
        return this.color;
    }

    BossType getStyle() {
        return this.style;
    }

    boolean isVisible() {
        return this.visible;
    }

    Collection<BossFlag> getFlags() {
        return Collections.unmodifiableSet(this.flags);
    }

    public String toString() {
        StringBuilder titleBuilder = new StringBuilder();
        for (BaseComponent component : this.title) {
            titleBuilder.append(component.toString()).append(", ");
        }
        return "BossBar(title=" + titleBuilder + ", color=" + (Object)((Object)this.color) + ", style=" + (Object)((Object)this.style) + ", flags=" + this.flags + ", health=" + this.health + ", visible=" + this.visible + ", players=" + this.players + ')';
    }

    public static Builder builder() {
        return new Builder();
    }

    private byte serializeFlags() {
        byte flagMask = 0;
        if (this.flags.contains((Object)BossFlag.DARKEN_SCREEN)) {
            flagMask = (byte)(flagMask | 1);
        }
        if (this.flags.contains((Object)BossFlag.PLAY_BOSS_MUSIC)) {
            flagMask = (byte)(flagMask | 2);
        }
        if (this.flags.contains((Object)BossFlag.CREATE_WORLD_FOG)) {
            flagMask = (byte)(flagMask | 4);
        }
        return flagMask;
    }

    private void setDivisions(@NotNull BossColor color, @NotNull BossType style) {
        BossBar packet = new BossBar(this.uuid, 4);
        packet.setColor(color.ordinal());
        packet.setDivision(style.ordinal());
        this.sendToAffected((DefinedPacket)packet);
    }

    private BossBar updateFlags() {
        BossBar packet = new BossBar(this.uuid, 5);
        packet.setFlags(this.serializeFlags());
        return packet;
    }

    private BossBar addPacket() {
        BossBar packet = new BossBar(this.uuid, 0);
        packet.setTitle(ComponentSerializer.toString((BaseComponent[])this.title));
        packet.setColor(this.color.ordinal());
        packet.setDivision(this.style.ordinal());
        packet.setHealth(this.health);
        packet.setFlags(this.serializeFlags());
        return packet;
    }

    private void sendToAffected(@NotNull DefinedPacket packet) {
        for (ProxiedPlayer player : this.players) {
            if (!player.isConnected() || !this.visible) continue;
            this.sendPacket(player, packet);
        }
    }

    private void sendPacket(@NotNull ProxiedPlayer player, @NotNull DefinedPacket packet) {
        if (player.getPendingConnection().getVersion() >= 107) {
            player.unsafe().sendPacket(packet);
        }
    }

    private BossBar removePacket() {
        return new BossBar(this.uuid, 1);
    }

    public static final class Builder {
        private BaseComponent[] title = new ComponentBuilder("KarmaAPI boss bar").color(ChatColor.AQUA).create();
        private BossColor color = BossColor.PINK;
        private BossType style = BossType.SOLID;
        private final Set<BossFlag> flags = EnumSet.noneOf(BossFlag.class);
        private float health = 1.0f;
        private final List<ProxiedPlayer> players = new ArrayList<ProxiedPlayer>();
        private boolean visible = true;

        public Builder title(BaseComponent ... title) {
            this.title = title;
            return this;
        }

        public Builder player(ProxiedPlayer ... playerArray) {
            this.players.addAll(Arrays.asList(playerArray));
            return this;
        }

        public Builder health(float health) {
            this.health = health;
            return this;
        }

        public Builder flags(BossFlag ... flags) {
            this.flags.addAll(Arrays.asList(flags));
            return this;
        }

        public Builder color(@NotNull BossColor color) {
            this.color = color;
            return this;
        }

        public Builder style(@NotNull BossType style) {
            this.style = style;
            return this;
        }

        public Builder visible(boolean visible) {
            this.visible = visible;
            return this;
        }

        public BarUtil build() {
            BarUtil bossBar = new BarUtil(this.title, this.color, this.style, this.health);
            bossBar.addFlags(this.flags.toArray(new BossFlag[0]));
            bossBar.setVisible(this.visible);
            bossBar.addPlayers(this.players);
            return bossBar;
        }
    }
}

