/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.bungee.scheduler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import ml.karmaconfigs.api.bungee.KarmaPlugin;
import ml.karmaconfigs.api.bungee.scheduler.SchedulerData;
import ml.karmaconfigs.api.common.timer.scheduler.Scheduler;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.TaskScheduler;

public class BungeeAsyncScheduler<T extends KarmaPlugin>
extends Scheduler {
    private static final Map<KarmaPlugin, SchedulerData> tasks = new ConcurrentHashMap<KarmaPlugin, SchedulerData>();
    private final T instance;

    public BungeeAsyncScheduler(T source) {
        SchedulerData data;
        this.instance = source;
        SchedulerData tmpData = tasks.getOrDefault(source, null);
        if (tmpData == null) {
            tmpData = new SchedulerData();
            tasks.put((KarmaPlugin)source, tmpData);
        }
        if ((data = tmpData).getScheduler() == null) {
            TaskScheduler scheduler = source.getProxy().getScheduler();
            scheduler.schedule(source, () -> scheduler.runAsync((Plugin)source, () -> {
                int next = data.getCurrentId() + 1;
                Runnable runnable = data.getTask(next);
                if (runnable != null) {
                    if (data.onTaskStart() != null) {
                        data.onTaskStart().accept(next);
                    }
                    runnable.run();
                    data.updateId(next);
                    if (data.onTaskEnd() != null) {
                        data.onTaskEnd().accept(next);
                    }
                }
            }), 0L, 1L, TimeUnit.SECONDS);
            data.updateScheduler(scheduler);
        }
    }

    @Override
    public final void onTaskStart(Consumer<Integer> taskId) {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaPlugin)this.instance, data);
        }
        data.taskStart = taskId;
    }

    @Override
    public final void onTaskComplete(Consumer<Integer> taskId) {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaPlugin)this.instance, data);
        }
        data.taskEnd = taskId;
    }

    @Override
    public final int queue(Runnable task) {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaPlugin)this.instance, data);
        }
        return data.addTask(task);
    }

    @Override
    public final int currentTask() {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaPlugin)this.instance, data);
        }
        return data.getCurrentId();
    }

    public final boolean hasMoreTasks() {
        SchedulerData data = tasks.getOrDefault(this.instance, null);
        if (data == null) {
            data = new SchedulerData();
            tasks.put((KarmaPlugin)this.instance, data);
        }
        return data.hasNext();
    }
}

