/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common;

import java.io.BufferedWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.api.common.JavaVM;
import ml.karmaconfigs.api.common.karma.KarmaAPI;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.utils.ConcurrentList;
import ml.karmaconfigs.api.common.utils.KarmaLogger;
import ml.karmaconfigs.api.common.utils.enums.Level;
import ml.karmaconfigs.api.common.utils.enums.LogCalendar;
import ml.karmaconfigs.api.common.utils.enums.LogExtension;
import ml.karmaconfigs.api.common.utils.file.PathUtilities;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class BufferedLogger
extends KarmaLogger
implements Serializable {
    private static final Map<KarmaSource, LogCalendar> calendar_type = new ConcurrentHashMap<KarmaSource, LogCalendar>();
    private static final Map<KarmaSource, LogExtension> ext_type = new ConcurrentHashMap<KarmaSource, LogExtension>();
    private static final Map<KarmaSource, String> header = new ConcurrentHashMap<KarmaSource, String>();
    private static final Map<KarmaSource, Boolean> header_added = new ConcurrentHashMap<KarmaSource, Boolean>();
    private static final Map<KarmaSource, List<String>> buffer = new ConcurrentHashMap<KarmaSource, List<String>>();
    private final KarmaSource source;

    public BufferedLogger(@NotNull KarmaSource s) {
        super(s);
        this.source = s;
        header.put(this.source, "# System information<br>\n<br>\n" + StringUtils.formatString((CharSequence)"Os name: {0}<br>\n", JavaVM.osName()) + StringUtils.formatString((CharSequence)"Os version: {0}<br>\n", JavaVM.osVersion()) + StringUtils.formatString((CharSequence)"Os model: {0}<br>\n", JavaVM.osModel()) + StringUtils.formatString((CharSequence)"Os arch: {0}<br>\n", JavaVM.osArchitecture()) + StringUtils.formatString((CharSequence)"Os max memory: {0}<br>\n", JavaVM.osMaxMemory()) + StringUtils.formatString((CharSequence)"Os free memory: {0}<br>\n", JavaVM.osFreeMemory()) + "\n# VM information<br>\n<br>\n" + StringUtils.formatString((CharSequence)"Architecture: {0}<br>\n", JavaVM.jvmArchitecture()) + StringUtils.formatString((CharSequence)"Max memory: {0}<br>\n", JavaVM.jvmMax()) + StringUtils.formatString((CharSequence)"Free memory: {0}<br>\n", JavaVM.jvmAvailable()) + StringUtils.formatString((CharSequence)"Processors: {0}<br>\n", JavaVM.jvmProcessors()) + StringUtils.formatString((CharSequence)"Version: {0}<br>\n", JavaVM.javaVersion()) + "\n# API Information<br>\n" + StringUtils.formatString((CharSequence)"API Version: {0}<br>\n", KarmaAPI.getVersion()) + StringUtils.formatString((CharSequence)"API Compiler: {0}<br>\n", KarmaAPI.getCompilerVersion()) + StringUtils.formatString((CharSequence)"API Date: {0}<br>\n", KarmaAPI.getBuildDate()) + "\n# Source information<br>\n" + StringUtils.formatString((CharSequence)"Name: {0}<br>\n", this.source.name()) + StringUtils.formatString((CharSequence)"Version: {0}<br>\n", this.source.version()) + StringUtils.formatString((CharSequence)"Description: {0}<br>\n", this.source.description().replace("\n", "<br>")) + StringUtils.formatString((CharSequence)"Author(s): {0}<br>\n", this.source.authors(true, "<br>- ")) + StringUtils.formatString((CharSequence)"Update URL: {0}<br>\n", this.source.updateURL()) + "\n# Beginning of log<br><br>\n\n");
        List stored_log = buffer.getOrDefault(this.source, new ConcurrentList());
        if (!header_added.getOrDefault(this.source, false).booleanValue()) {
            stored_log.add(header.get(this.source));
            header_added.put(this.source, true);
            buffer.put(this.source, stored_log);
        }
    }

    public BufferedLogger calendar(LogCalendar calendar) {
        calendar_type.put(this.source, calendar);
        return this;
    }

    public BufferedLogger extension(LogExtension extension) {
        ext_type.put(this.source, extension);
        return this;
    }

    @Override
    public void scheduleLog(@NotNull Level level, @NotNull CharSequence info, Object ... replaces) {
        this.source.async().queue(() -> this.logInfo(level, this.printInfo(), info, replaces));
    }

    @Override
    public void scheduleLog(@NotNull Level level, @NotNull Throwable error) {
        this.source.async().queue(() -> this.logError(level, this.printError(), error));
    }

    @Override
    public void scheduleLogOption(Level level, boolean print, CharSequence info, Object ... replaces) {
        this.source.async().queue(() -> this.logInfo(level, print, info, replaces));
    }

    @Override
    public void scheduleLogOption(Level level, boolean print, Throwable error) {
        this.source.async().queue(() -> this.logError(level, print, error));
    }

    @Override
    public void syncedLog(Level level, CharSequence info, Object ... replaces) {
        this.source.sync().queue(() -> this.logInfo(level, this.printInfo(), info, replaces));
    }

    @Override
    public void syncedLog(Level level, Throwable error) {
        this.source.sync().queue(() -> this.logError(level, this.printError(), error));
    }

    @Override
    public void syncedLogOption(Level level, boolean print, CharSequence info, Object ... replaces) {
        this.source.sync().queue(() -> this.logInfo(level, print, info, replaces));
    }

    @Override
    public void syncedLogOption(Level level, boolean print, Throwable error) {
        this.source.sync().queue(() -> this.logError(level, print, error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logInfo(Level level, boolean print, CharSequence info, Object ... replaces) {
        List stored_log = buffer.getOrDefault(this.source, new ConcurrentList());
        String time = this.fetchTime(calendar_type.getOrDefault(this.source, LogCalendar.GREGORIAN));
        try {
            if (!header_added.getOrDefault(this.source, false).booleanValue()) {
                stored_log.add(header.get(this.source));
                header_added.put(this.source, true);
            }
            stored_log.add(StringUtils.formatString((CharSequence)"[ {0} - {1} ] {2}<br>", level.name(), time, StringUtils.formatString(info, replaces)));
            buffer.put(this.source, stored_log);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            if (print) {
                this.source.console().send(info, level);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void logError(Level level, boolean print, Throwable error) {
        Throwable prefix;
        List stored_log = buffer.getOrDefault(this.source, new ConcurrentList());
        String time = this.fetchTime(calendar_type.getOrDefault(this.source, LogCalendar.GREGORIAN));
        try {
            if (!header_added.getOrDefault(this.source, false).booleanValue()) {
                stored_log.add(header.get(this.source));
                header_added.put(this.source, true);
            }
            prefix = new Throwable(error);
            stored_log.add(StringUtils.formatString((CharSequence)"[ {0} - {1} ] {2}\n", level.name(), time, prefix.fillInStackTrace()));
            stored_log.add("```java\n");
            for (StackTraceElement element : error.getStackTrace()) {
                stored_log.add(element + "\n");
            }
            stored_log.add("```");
            buffer.put(this.source, stored_log);
            prefix = new Throwable(error);
            if (!print) return;
        }
        catch (Throwable ex) {
            Throwable prefix2;
            try {
                ex.printStackTrace();
                prefix2 = new Throwable(error);
                if (!print) return;
            }
            catch (Throwable throwable) {
                Throwable prefix3 = new Throwable(error);
                if (!print) throw throwable;
                this.source.console().send((CharSequence)"An internal error occurred ( {0} )", level, prefix3.fillInStackTrace());
                for (StackTraceElement element : error.getStackTrace()) {
                    this.source.console().send((CharSequence)element.toString(), Level.INFO);
                }
                throw throwable;
            }
            this.source.console().send((CharSequence)"An internal error occurred ( {0} )", level, prefix2.fillInStackTrace());
            for (StackTraceElement element : error.getStackTrace()) {
                this.source.console().send((CharSequence)element.toString(), Level.INFO);
            }
            return;
        }
        this.source.console().send((CharSequence)"An internal error occurred ( {0} )", level, prefix.fillInStackTrace());
        for (StackTraceElement element : error.getStackTrace()) {
            this.source.console().send((CharSequence)element.toString(), Level.INFO);
        }
        return;
    }

    @Override
    public synchronized void clearLog() {
        buffer.remove(this.source);
    }

    @Override
    public boolean flush() {
        try {
            BufferedWriter writer = Files.newBufferedWriter(this.getLoggerFile(ext_type.getOrDefault(this.source, LogExtension.MARKDOWN)), StandardCharsets.UTF_8, new OpenOption[0]);
            List<String> lines = buffer.remove(this.source);
            for (String str : lines) {
                writer.write(str + "\n");
            }
            writer.flush();
            writer.close();
            header_added.put(this.source, false);
            return true;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    protected Path getLoggerFile(LogExtension type) {
        Calendar calendar = Calendar.getInstance();
        String year = String.valueOf(calendar.get(1));
        String month = calendar.getDisplayName(2, 2, Locale.getDefault());
        String day = String.valueOf(calendar.get(5));
        Path log = this.source.getDataPath().resolve("logs").resolve(year).resolve(month).resolve(day + "." + type.fileExtension());
        if (Files.exists(log, new LinkOption[0])) {
            Path target = this.source.getDataPath().resolve("logs").resolve(year).resolve(month).resolve(day).resolve(System.currentTimeMillis() + "." + type.fileExtension());
            if (!Files.exists(target, new LinkOption[0])) {
                PathUtilities.create(target);
            }
            try {
                Files.move(target, log, StandardCopyOption.REPLACE_EXISTING);
                PathUtilities.create(log);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        return log;
    }
}

