/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.karma;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ml.karmaconfigs.api.common.karma.KarmaAPI;
import ml.karmaconfigs.api.common.karma.KarmaSource;
import ml.karmaconfigs.api.common.utils.PrefixConsoleData;
import org.jetbrains.annotations.ApiStatus;

public final class APISource
implements KarmaSource {
    private static final Map<String, KarmaSource> sources = new ConcurrentHashMap<String, KarmaSource>();
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static String DEFAULT_SOURCE = "karmaapi";
    private static String DEFAULT = "karmaapi";

    APISource() {
        try {
            APISource.addProvider(this);
            PrefixConsoleData data = new PrefixConsoleData(this);
            data.setOkPrefix("&7[ KarmaAPI ] &3");
            data.setInfoPrefix("&b[ KarmaAPI ] &3");
            data.setWarnPrefix("&e[ KarmaAPI ] &3");
            data.setGravePrefix("&c[ KarmaAPI ] &3");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void addProvider(KarmaSource src) throws IllegalStateException {
        String identifier = src.name().toLowerCase();
        KarmaSource stored = sources.getOrDefault(identifier, null);
        if (stored != null) {
            throw new IllegalStateException("A source from " + src.getClass().getName() + " tried to add an already added source " + stored.name() + " by author(s): " + stored.authors(false, ", "));
        }
        sources.put(identifier, src);
    }

    public static void updateProvider(String name, KarmaSource target) throws IllegalStateException {
        String identifier = name.toLowerCase();
        KarmaSource stored = sources.getOrDefault(identifier, null);
        if (!stored.srcEquals(target)) {
            throw new IllegalStateException("A source from " + target.getClass().getName() + " tried to overwrite source " + stored.name() + " by author(s): " + stored.authors(false, ", "));
        }
        sources.put(identifier, target);
    }

    public static boolean hasProvider(String name) {
        String identifier = name.toLowerCase();
        KarmaSource stored = sources.getOrDefault(identifier, null);
        if (!identifier.equalsIgnoreCase("KarmaAPI")) {
            return stored != null;
        }
        return true;
    }

    public static KarmaSource loadProvider(String name) throws IllegalArgumentException {
        String identifier = name.toLowerCase();
        KarmaSource stored = sources.getOrDefault(identifier, null);
        if (!identifier.equalsIgnoreCase("KarmaAPI")) {
            if (stored != null) {
                return stored;
            }
            throw new IllegalArgumentException("KarmaSource with name " + name + " as not been registered as provider");
        }
        if (stored != null) {
            return stored;
        }
        return new APISource();
    }

    public static void defineDefault(KarmaSource def) throws SecurityException {
        String identifier = def.name().toLowerCase();
        if (DEFAULT.equalsIgnoreCase("KarmaAPI")) {
            DEFAULT = identifier;
        } else if (!identifier.equalsIgnoreCase(DEFAULT)) {
            throw new SecurityException("Module " + def + " tried to change default source");
        }
    }

    public static KarmaSource getOriginal(boolean forceKarma) {
        if (forceKarma) {
            return APISource.loadProvider("KarmaAPI");
        }
        return APISource.loadProvider(DEFAULT);
    }

    @Override
    public String name() {
        return "KarmaAPI";
    }

    @Override
    public String version() {
        return KarmaAPI.getVersion();
    }

    @Override
    public String description() {
        return "KarmaAPI source";
    }

    @Override
    public String[] authors() {
        return new String[]{"KarmaDev"};
    }

    @Override
    public String updateURL() {
        return "";
    }
}

