/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.karma.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import ml.karmaconfigs.api.common.karma.loader.SourceBootstrap;

@Deprecated
public final class KarmaSourceLoader
extends URLClassLoader {
    public KarmaSourceLoader(ClassLoader currentLoader, URL subJar) {
        super(new URL[]{KarmaSourceLoader.extractJar(subJar)}, currentLoader);
    }

    public KarmaSourceLoader(ClassLoader currentLoader, File subJar) throws IOException {
        super(new URL[]{KarmaSourceLoader.extractJar(subJar.toURI().toURL())}, currentLoader);
    }

    public KarmaSourceLoader(ClassLoader currentLoader, Path subJar) throws IOException {
        super(new URL[]{KarmaSourceLoader.extractJar(subJar.toFile().toURI().toURL())}, currentLoader);
    }

    private static URL extractJar(URL jarFile) {
        if (jarFile != null) {
            Path tempFile;
            File file = new File(jarFile.getPath().replaceAll("%20", " "));
            try {
                tempFile = Files.createTempFile(file.getName(), ".jar.tmp", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create a temporary file", e);
            }
            tempFile.toFile().deleteOnExit();
            try {
                InputStream in = jarFile.openStream();
                try {
                    Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
                    in.close();
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable1) {
                            throwable.addSuppressed(throwable1);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to copy jar-in-jar to temporary path", e);
            }
            try {
                return tempFile.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Unable to get URL from path", e);
            }
        }
        throw new RuntimeException("Unable to find sub jar file");
    }

    public void addJarToClasspath(URL url) {
        this.addURL(url);
    }

    public void deleteJarResource() {
        URL[] urls = this.getURLs();
        if (urls.length == 0) {
            return;
        }
        try {
            Path path = Paths.get(urls[0].toURI());
            Files.deleteIfExists(path);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public <T> SourceBootstrap instantiate(String bootstrapClass, Class<T> loaderPluginType, T loaderPlugin) {
        Constructor<SourceBootstrap> constructor;
        Class<SourceBootstrap> plugin;
        try {
            plugin = this.loadClass(bootstrapClass).asSubclass(SourceBootstrap.class);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to load bootstrap class", e);
        }
        try {
            constructor = plugin.getConstructor(loaderPluginType);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to get bootstrap constructor", e);
        }
        try {
            return constructor.newInstance(loaderPlugin);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to create bootstrap plugin instance", e);
        }
    }

    public <T> SourceBootstrap instantiate(String bootstrapClass) {
        Class<SourceBootstrap> plugin;
        try {
            plugin = this.loadClass(bootstrapClass).asSubclass(SourceBootstrap.class);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to load bootstrap class", e);
        }
        try {
            return plugin.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Unable to get bootstrap constructor", e);
        }
    }

    public void closeLoader() {
        this.deleteJarResource();
        try {
            this.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

