/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.rgb;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ml.karmaconfigs.api.common.utils.string.StringUtils;

public final class RGBTextComponent
implements Serializable {
    private final boolean parseSimple;
    private final boolean parseHEX;
    private final Pattern hexPattern = Pattern.compile("#[a-fA-f0-9]{6}");
    private final Pattern simplePattern = Pattern.compile("rgb\\([0-9]{1,3},[0-9]{1,3},[0-9]{1,3}\\)", 2);

    public RGBTextComponent(boolean simple, boolean hex) {
        this.parseSimple = simple;
        this.parseHEX = hex;
    }

    public String parse(String message) {
        if (this.parseHEX || this.parseSimple) {
            try {
                if (this.parseSimple) {
                    Matcher simpleMatcher = this.simplePattern.matcher(message);
                    while (simpleMatcher.find()) {
                        String un_parsed = message.substring(simpleMatcher.start(), simpleMatcher.end());
                        un_parsed = StringUtils.replaceLast(un_parsed.replaceFirst("\\(", ""), ")", "");
                        String[] rgb = un_parsed.split(",");
                        int red = Integer.parseInt(rgb[0]);
                        int green = Integer.parseInt(rgb[1]);
                        int blue = Integer.parseInt(rgb[2]);
                        message = message.replace(un_parsed, this.rgbToHex(red, green, blue));
                        simpleMatcher = this.simplePattern.matcher(message);
                    }
                }
                if (this.parseHEX) {
                    Matcher hexMatcher = this.hexPattern.matcher(message);
                    while (hexMatcher.find()) {
                        String hex = message.substring(hexMatcher.start(), hexMatcher.end());
                        message = message.replace(hex, this.hexToColor(hex));
                        hexMatcher = this.hexPattern.matcher(message);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return StringUtils.toColor(message);
    }

    private String decToHEX(int n) {
        char[] hexDeciNum = new char[2];
        int i = 0;
        while (n != 0) {
            int temp = n % 16;
            hexDeciNum[i] = temp < 10 ? (char)(temp + 48) : (char)(temp + 55);
            ++i;
            n /= 16;
        }
        String hexCode = "";
        if (i == 2) {
            hexCode = hexCode + hexDeciNum[0];
            hexCode = hexCode + hexDeciNum[1];
        } else if (i == 1) {
            hexCode = "0";
            hexCode = hexCode + hexDeciNum[0];
        } else if (i == 0) {
            hexCode = "00";
        }
        return hexCode;
    }

    private String rgbToHex(int R, int G, int B) {
        if (R >= 0 && R <= 255 && G >= 0 && G <= 255 && B >= 0 && B <= 255) {
            String hexCode = "#";
            hexCode = hexCode + this.decToHEX(R);
            hexCode = hexCode + this.decToHEX(G);
            hexCode = hexCode + this.decToHEX(B);
            return hexCode;
        }
        return "-1";
    }

    private int[] hexToRGB(String hex) {
        int red = Integer.valueOf(hex.substring(1, 3), 16);
        int green = Integer.valueOf(hex.substring(3, 5), 16);
        int blue = Integer.valueOf(hex.substring(5, 7), 16);
        return new int[]{red, green, blue};
    }

    private String hexToColor(String argument) {
        try {
            Class<?> inst = Class.forName("net.md_5.bungee.api.ChatColor");
            Method method = inst.getMethod("of", String.class);
            method.setAccessible(true);
            return String.valueOf(method.invoke(inst, argument));
        }
        catch (Throwable ex) {
            try {
                Class<?> inst = Class.forName("net.kyori.adventure.text.format.TextColor");
                Method method = inst.getMethod("color", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                int[] rgb = this.hexToRGB(argument);
                Object textColor = method.invoke(inst, rgb[0], rgb[2], rgb[3]);
                Class<?> clazz = textColor.getClass();
                Method examinableName = clazz.getMethod("examinableName", new Class[0]);
                return String.valueOf(examinableName.invoke(textColor, new Object[0]));
            }
            catch (Throwable exc) {
                exc.printStackTrace();
                return "";
            }
        }
    }
}

