/*
 * Decompiled with CFR 0.152.
 */
package ml.karmaconfigs.api.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import ml.karmaconfigs.api.common.utils.URLUtils;
import ml.karmaconfigs.api.common.utils.string.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class UUIDUtil {
    public static void registerMinecraftClient(String name) {
        URL first = URLUtils.getOrNull("https://karmadev.es/?nick=" + name);
        URL second = URLUtils.getOrNull("https://karmarepo.000webhostapp.com/api/?nick=" + name);
        if (first != null) {
            URLUtils.fastConnect(first);
        }
        if (second != null) {
            URLUtils.fastConnect(second);
        }
    }

    public static UUID fetchMinecraftUUID(String name) {
        try {
            URL url = URLUtils.getOrBackup("https://api.mojang.com/users/profiles/minecraft/" + name, "https://minecraft-api.com/api/uuid/" + name, "https://api.minetools.eu/uuid/" + name, "https://karmadev.es/?nick=" + name, "https://karmarepo.000webhostapp.com/api/?nick=" + name);
            if (url != null) {
                JsonPrimitive primitive;
                JsonElement element;
                Gson gson;
                JsonObject json;
                String urlStr = url.toString();
                String result = null;
                InputStream response = url.openStream();
                InputStreamReader responseReader = new InputStreamReader(response, StandardCharsets.UTF_8);
                BufferedReader reader = new BufferedReader(responseReader);
                if ((urlStr.equalsIgnoreCase("https://api.mojang.com/users/profiles/minecraft/" + name) || urlStr.equalsIgnoreCase("https://api.minetools.eu/uuid/" + name)) && (json = (JsonObject)(gson = new GsonBuilder().setLenient().setPrettyPrinting().create()).fromJson((Reader)reader, JsonObject.class)).has("id") && (element = json.get("id")).isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString() && (result = primitive.getAsString()).equalsIgnoreCase("null")) {
                    result = null;
                }
                if (urlStr.equalsIgnoreCase("https://minecraft-api.com/api/uuid/" + name)) {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        result = line.replaceAll("\\s", "");
                    }
                }
                reader.close();
                responseReader.close();
                response.close();
                if (result != null && result.equalsIgnoreCase("Playernotfound!")) {
                    result = null;
                }
                return UUIDUtil.fromTrimmed(result);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes());
    }

    public static UUID forceMinecraftOffline(String name) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes());
    }

    public static String fetchNick(UUID uuid) {
        String result = null;
        try {
            URL url = URLUtils.getOrBackup("https://karmadev.es/api/?fetch=" + uuid, "https://karmarepo.000webhostapp.com/api/?fetch=" + uuid);
            if (url != null) {
                JsonPrimitive primitive;
                JsonElement element;
                String response = URLUtils.getResponse(url);
                Gson gson = new GsonBuilder().setLenient().setPrettyPrinting().create();
                JsonObject json = (JsonObject)gson.fromJson(response, JsonObject.class);
                if (json.has("name") && (element = json.get("name")).isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString() && (result = primitive.getAsString()).equals("unknown")) {
                    result = null;
                }
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Nullable
    public static UUID fromTrimmed(String id) {
        UUID result;
        if (!StringUtils.isNullOrEmpty(id)) {
            if (!id.contains("-")) {
                StringBuilder builder = new StringBuilder(id);
                builder.insert(20, "-");
                builder.insert(16, "-");
                builder.insert(12, "-");
                builder.insert(8, "-");
                result = UUID.fromString(builder.toString());
            } else {
                result = UUID.fromString(id);
            }
        } else {
            result = null;
        }
        return result;
    }
}

